/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.function.ToLongFunction;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.RowWalker;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class RowBasedCursor<RowType>
implements Cursor {
    private final RowWalker<RowType> rowWalker;
    private final ToLongFunction<RowType> timestampFunction;
    private final Interval interval;
    private final boolean descending;
    private final DateTime cursorTime;
    private final ColumnSelectorFactory columnSelectorFactory;
    private final ValueMatcher valueMatcher;
    private long rowId = 0L;

    RowBasedCursor(RowWalker<RowType> rowWalker, RowAdapter<RowType> rowAdapter, @Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, RowSignature rowSignature) {
        this.rowWalker = rowWalker;
        this.timestampFunction = rowAdapter.timestampFunction();
        this.interval = interval;
        this.descending = descending;
        this.cursorTime = gran.toDateTime(interval.getStartMillis());
        this.columnSelectorFactory = virtualColumns.wrap(new RowBasedColumnSelectorFactory<Object>(rowWalker::currentRow, () -> this.rowId, rowAdapter, rowSignature, false, false));
        this.valueMatcher = filter == null ? BooleanValueMatcher.of(true) : filter.makeMatcher(this.columnSelectorFactory);
        rowWalker.skipToDateTime(descending ? interval.getEnd().minus(1L) : interval.getStart(), descending);
        this.advanceToMatchingRow();
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return this.columnSelectorFactory;
    }

    @Override
    public DateTime getTime() {
        return this.cursorTime;
    }

    @Override
    public void advance() {
        this.advanceUninterruptibly();
        BaseQuery.checkInterrupted();
    }

    @Override
    public void advanceUninterruptibly() {
        this.rowWalker.advance();
        ++this.rowId;
        this.advanceToMatchingRow();
    }

    @Override
    public boolean isDone() {
        return this.rowWalker.isDone() || !this.interval.contains(this.timestampFunction.applyAsLong(this.rowWalker.currentRow()));
    }

    @Override
    public boolean isDoneOrInterrupted() {
        return this.isDone() || Thread.currentThread().isInterrupted();
    }

    @Override
    public void reset() {
        this.rowId = 0L;
        this.rowWalker.reset();
        this.rowWalker.skipToDateTime(this.descending ? this.interval.getEnd().minus(1L) : this.interval.getStart(), this.descending);
        this.advanceToMatchingRow();
    }

    private void advanceToMatchingRow() {
        while (!this.isDone() && !this.valueMatcher.matches()) {
            this.rowWalker.advance();
            ++this.rowId;
        }
    }
}

