/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class IncrementalIndexSegment
implements Segment {
    private final IncrementalIndex index;
    private final SegmentId segmentId;

    public IncrementalIndexSegment(IncrementalIndex index, SegmentId segmentId) {
        this.index = index;
        this.segmentId = segmentId;
    }

    @Override
    public SegmentId getId() {
        return this.segmentId;
    }

    @Override
    public Interval getDataInterval() {
        return this.index.getInterval();
    }

    @Override
    public QueryableIndex asQueryableIndex() {
        return null;
    }

    @Override
    public StorageAdapter asStorageAdapter() {
        return new IncrementalIndexStorageAdapter(this.index);
    }

    @Override
    public void close() {
        this.index.close();
    }
}

