/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.ColumnSelectorColumnIndexSelector;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.Filters;

public class FilterAnalysis {
    private final Filter postFilter;
    private final ImmutableBitmap preFilterBitmap;

    public static FilterAnalysis analyzeFilter(@Nullable Filter filter, ColumnSelectorColumnIndexSelector indexSelector, @Nullable QueryMetrics queryMetrics, int numRows) {
        DefaultBitmapResultFactory bitmapResultFactory;
        ImmutableBitmap preFilterBitmap;
        List<Filter> preFilters;
        ArrayList<Filter> postFilters = new ArrayList<Filter>();
        int preFilteredRows = numRows;
        if (filter == null) {
            preFilters = Collections.emptyList();
        } else {
            preFilters = new ArrayList();
            if (filter instanceof AndFilter) {
                for (Filter subfilter : ((AndFilter)filter).getFilters()) {
                    BitmapColumnIndex columnIndex = subfilter.getBitmapColumnIndex(indexSelector);
                    if (columnIndex == null) {
                        postFilters.add(subfilter);
                        continue;
                    }
                    preFilters.add(subfilter);
                    if (columnIndex.getIndexCapabilities().isExact()) continue;
                    postFilters.add(subfilter);
                }
            } else {
                BitmapColumnIndex columnIndex = filter.getBitmapColumnIndex(indexSelector);
                if (columnIndex == null) {
                    postFilters.add(filter);
                } else {
                    preFilters.add(filter);
                    if (!columnIndex.getIndexCapabilities().isExact()) {
                        postFilters.add(filter);
                    }
                }
            }
        }
        if (preFilters.isEmpty()) {
            preFilterBitmap = null;
        } else if (queryMetrics != null) {
            bitmapResultFactory = queryMetrics.makeBitmapResultFactory(indexSelector.getBitmapFactory());
            long bitmapConstructionStartNs = System.nanoTime();
            preFilterBitmap = AndFilter.getBitmapIndex(indexSelector, bitmapResultFactory, preFilters);
            preFilteredRows = preFilterBitmap.size();
            queryMetrics.reportBitmapConstructionTime(System.nanoTime() - bitmapConstructionStartNs);
        } else {
            bitmapResultFactory = new DefaultBitmapResultFactory(indexSelector.getBitmapFactory());
            preFilterBitmap = AndFilter.getBitmapIndex(indexSelector, bitmapResultFactory, preFilters);
        }
        if (queryMetrics != null) {
            queryMetrics.preFilters(new ArrayList<Filter>(preFilters));
            queryMetrics.postFilters(postFilters);
            queryMetrics.reportSegmentRows(numRows);
            queryMetrics.reportPreFilteredRows(preFilteredRows);
        }
        return new FilterAnalysis(preFilterBitmap, Filters.maybeAnd(postFilters).orElse(null));
    }

    public FilterAnalysis(@Nullable ImmutableBitmap preFilterBitmap, @Nullable Filter postFilter) {
        this.preFilterBitmap = preFilterBitmap;
        this.postFilter = postFilter;
    }

    @Nullable
    public ImmutableBitmap getPreFilterBitmap() {
        return this.preFilterBitmap;
    }

    @Nullable
    public Filter getPostFilter() {
        return this.postFilter;
    }
}

