/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn.types;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.druid.query.topn.types.DoubleTopNColumnAggregatesProcessor;
import org.apache.druid.query.topn.types.FloatTopNColumnAggregatesProcessor;
import org.apache.druid.query.topn.types.LongTopNColumnAggregatesProcessor;
import org.apache.druid.query.topn.types.StringTopNColumnAggregatesProcessor;
import org.apache.druid.query.topn.types.TopNColumnAggregatesProcessor;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;

public class TopNColumnAggregatesProcessorFactory
implements ColumnSelectorStrategyFactory<TopNColumnAggregatesProcessor<?>> {
    private final ColumnType dimensionType;

    public TopNColumnAggregatesProcessorFactory(ColumnType dimensionType) {
        this.dimensionType = (ColumnType)Preconditions.checkNotNull((Object)dimensionType, (Object)"dimensionType");
    }

    @Override
    public TopNColumnAggregatesProcessor<?> makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
        if (capabilities.is((TypeDescriptor)ValueType.STRING)) {
            return new StringTopNColumnAggregatesProcessor(capabilities, this.dimensionType);
        }
        if (capabilities.isNumeric()) {
            ColumnType strategyType;
            Function<Object, Comparable<?>> converter;
            if (this.dimensionType.isNumeric()) {
                converter = DimensionHandlerUtils.converterFromTypeToType((TypeSignature<ValueType>)this.dimensionType, (TypeSignature<ValueType>)this.dimensionType);
                strategyType = this.dimensionType;
            } else {
                converter = DimensionHandlerUtils.converterFromTypeToType(capabilities, (TypeSignature<ValueType>)this.dimensionType);
                strategyType = capabilities.toColumnType();
            }
            switch ((ValueType)strategyType.getType()) {
                case LONG: {
                    return new LongTopNColumnAggregatesProcessor(converter);
                }
                case FLOAT: {
                    return new FloatTopNColumnAggregatesProcessor(converter);
                }
                case DOUBLE: {
                    return new DoubleTopNColumnAggregatesProcessor(converter);
                }
            }
        }
        throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{capabilities.asTypeString()});
    }
}

