/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.BySegmentResultValue;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.ResultGranularTimestampComparator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorUtil;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.topn.BySegmentTopNResultValue;
import org.apache.druid.query.topn.DefaultTopNQueryMetricsFactory;
import org.apache.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.druid.query.topn.TopNBinaryFn;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryEngine;
import org.apache.druid.query.topn.TopNQueryMetrics;
import org.apache.druid.query.topn.TopNQueryMetricsFactory;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.joda.time.DateTime;

public class TopNQueryQueryToolChest
extends QueryToolChest<Result<TopNResultValue>, TopNQuery> {
    private static final byte TOPN_QUERY = 1;
    private static final TypeReference<Result<TopNResultValue>> TYPE_REFERENCE = new TypeReference<Result<TopNResultValue>>(){};
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private final TopNQueryConfig config;
    private final TopNQueryMetricsFactory queryMetricsFactory;

    @VisibleForTesting
    public TopNQueryQueryToolChest(TopNQueryConfig config) {
        this(config, DefaultTopNQueryMetricsFactory.instance());
    }

    @Inject
    public TopNQueryQueryToolChest(TopNQueryConfig config, TopNQueryMetricsFactory queryMetricsFactory) {
        this.config = config;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    protected static String[] extractFactoryName(List<AggregatorFactory> aggregatorFactories) {
        return (String[])aggregatorFactories.stream().map(AggregatorFactory::getName).toArray(String[]::new);
    }

    private static List<PostAggregator> prunePostAggregators(TopNQuery query) {
        return AggregatorUtil.pruneDependentPostAgg(query.getPostAggregatorSpecs(), query.getTopNMetricSpec().getMetricName(query.getDimensionSpec()));
    }

    @Override
    public BinaryOperator<Result<TopNResultValue>> createMergeFn(Query<Result<TopNResultValue>> query) {
        TopNQuery topNQuery = (TopNQuery)query;
        return new TopNBinaryFn(topNQuery.getGranularity(), topNQuery.getDimensionSpec(), topNQuery.getTopNMetricSpec(), topNQuery.getThreshold(), topNQuery.getAggregatorSpecs(), topNQuery.getPostAggregatorSpecs());
    }

    @Override
    public Comparator<Result<TopNResultValue>> createResultComparator(Query<Result<TopNResultValue>> query) {
        return ResultGranularTimestampComparator.create(query.getGranularity(), query.isDescending());
    }

    public TopNQueryMetrics makeMetrics(TopNQuery query) {
        TopNQueryMetrics queryMetrics = this.queryMetricsFactory.makeMetrics();
        queryMetrics.query(query);
        return queryMetrics;
    }

    @Override
    public Function<Result<TopNResultValue>, Result<TopNResultValue>> makePreComputeManipulatorFn(final TopNQuery query, final MetricManipulationFn fn) {
        return new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){
            private String dimension;
            private final List<PostAggregator> prunedAggs;
            private final AggregatorFactory[] aggregatorFactories;
            private final String[] aggFactoryNames;
            {
                this.dimension = query.getDimensionSpec().getOutputName();
                this.prunedAggs = TopNQueryQueryToolChest.prunePostAggregators(query);
                this.aggregatorFactories = query.getAggregatorSpecs().toArray(new AggregatorFactory[0]);
                this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
            }

            public Result<TopNResultValue> apply(Result<TopNResultValue> result) {
                ArrayList serializedValues = Lists.newArrayList((Iterable)Iterables.transform((Iterable)result.getValue(), (Function)new Function<DimensionAndMetricValueExtractor, Map<String, Object>>(){

                    public Map<String, Object> apply(DimensionAndMetricValueExtractor input) {
                        HashMap values = Maps.newHashMapWithExpectedSize((int)(aggregatorFactories.length + prunedAggs.size() + 1));
                        for (int i = 0; i < aggregatorFactories.length; ++i) {
                            String aggName = aggFactoryNames[i];
                            values.put(aggName, fn.manipulate(aggregatorFactories[i], input.getMetric(aggName)));
                        }
                        for (PostAggregator postAgg : prunedAggs) {
                            String name = postAgg.getName();
                            Object calculatedPostAgg = input.getMetric(name);
                            if (calculatedPostAgg != null) {
                                values.put(name, calculatedPostAgg);
                                continue;
                            }
                            values.put(name, postAgg.compute(values));
                        }
                        values.put(dimension, input.getDimensionValue(dimension));
                        return values;
                    }
                }));
                return new Result<TopNResultValue>(result.getTimestamp(), new TopNResultValue(serializedValues));
            }
        };
    }

    @Override
    public Function<Result<TopNResultValue>, Result<TopNResultValue>> makePostComputeManipulatorFn(final TopNQuery query, final MetricManipulationFn fn) {
        return new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){
            private String dimension;
            private final AggregatorFactory[] aggregatorFactories;
            private final String[] aggFactoryNames;
            private final PostAggregator[] postAggregators;
            {
                this.dimension = query.getDimensionSpec().getOutputName();
                this.aggregatorFactories = query.getAggregatorSpecs().toArray(new AggregatorFactory[0]);
                this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
                this.postAggregators = query.getPostAggregatorSpecs().toArray(new PostAggregator[0]);
            }

            public Result<TopNResultValue> apply(Result<TopNResultValue> result) {
                ArrayList serializedValues = Lists.newArrayList((Iterable)Iterables.transform((Iterable)result.getValue(), (Function)new Function<DimensionAndMetricValueExtractor, Map<String, Object>>(){

                    public Map<String, Object> apply(DimensionAndMetricValueExtractor input) {
                        HashMap values = Maps.newHashMapWithExpectedSize((int)(aggregatorFactories.length + query.getPostAggregatorSpecs().size() + 1));
                        for (String name : aggFactoryNames) {
                            values.put(name, input.getMetric(name));
                        }
                        values.put(dimension, input.getDimensionValue(dimension));
                        for (PostAggregator postAgg : postAggregators) {
                            Object calculatedPostAgg = input.getMetric(postAgg.getName());
                            if (calculatedPostAgg != null) {
                                values.put(postAgg.getName(), calculatedPostAgg);
                                continue;
                            }
                            values.put(postAgg.getName(), postAgg.compute(values));
                        }
                        for (int i = 0; i < aggFactoryNames.length; ++i) {
                            String name = aggFactoryNames[i];
                            values.put(name, fn.manipulate(aggregatorFactories[i], input.getMetric(name)));
                        }
                        return values;
                    }
                }));
                return new Result<TopNResultValue>(result.getTimestamp(), new TopNResultValue(serializedValues));
            }
        };
    }

    @Override
    public TypeReference<Result<TopNResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TopNResultValue>, Object, TopNQuery> getCacheStrategy(final TopNQuery query) {
        return new CacheStrategy<Result<TopNResultValue>, Object, TopNQuery>(){
            private final List<AggregatorFactory> aggs;
            private final List<PostAggregator> postAggs;
            {
                this.aggs = Lists.newArrayList(query.getAggregatorSpecs());
                this.postAggs = AggregatorUtil.pruneDependentPostAgg(query.getPostAggregatorSpecs(), query.getTopNMetricSpec().getMetricName(query.getDimensionSpec()));
            }

            @Override
            public boolean isCacheable(TopNQuery query2, boolean willMergeRunners) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(TopNQuery query2) {
                CacheKeyBuilder builder = new CacheKeyBuilder(1).appendCacheable((Cacheable)query2.getDimensionSpec()).appendCacheable((Cacheable)query2.getTopNMetricSpec()).appendInt(query2.getThreshold()).appendCacheable((Cacheable)query2.getGranularity()).appendCacheable((Cacheable)query2.getDimensionsFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheable((Cacheable)query2.getVirtualColumns());
                List postAggregators = TopNQueryQueryToolChest.prunePostAggregators(query2);
                if (!postAggregators.isEmpty()) {
                    builder.appendCacheablesIgnoringOrder((Collection)postAggregators);
                }
                return builder.build();
            }

            @Override
            public byte[] computeResultLevelCacheKey(TopNQuery query2) {
                CacheKeyBuilder builder = new CacheKeyBuilder(1).appendCacheable((Cacheable)query2.getDimensionSpec()).appendCacheable((Cacheable)query2.getTopNMetricSpec()).appendInt(query2.getThreshold()).appendCacheable((Cacheable)query2.getGranularity()).appendCacheable((Cacheable)query2.getDimensionsFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheable((Cacheable)query2.getVirtualColumns()).appendCacheables(query2.getPostAggregatorSpecs());
                return builder.build();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TopNResultValue>, Object> prepareForCache(final boolean isResultLevelCache) {
                return new Function<Result<TopNResultValue>, Object>(){
                    private final String[] aggFactoryNames;
                    {
                        this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
                    }

                    public Object apply(Result<TopNResultValue> input) {
                        ArrayList results = Lists.newArrayList((Iterable)input.getValue());
                        ArrayList retVal = Lists.newArrayListWithCapacity((int)(results.size() + 1));
                        retVal.add(input.getTimestamp().getMillis());
                        for (DimensionAndMetricValueExtractor result : results) {
                            ArrayList vals = Lists.newArrayListWithCapacity((int)(this.aggFactoryNames.length + 2));
                            vals.add(result.getDimensionValue(query.getDimensionSpec().getOutputName()));
                            for (String aggName : this.aggFactoryNames) {
                                vals.add(result.getMetric(aggName));
                            }
                            if (isResultLevelCache) {
                                for (PostAggregator postAgg : query.getPostAggregatorSpecs()) {
                                    vals.add(result.getMetric(postAgg.getName()));
                                }
                            }
                            retVal.add(vals);
                        }
                        return retVal;
                    }
                };
            }

            @Override
            public Function<Object, Result<TopNResultValue>> pullFromCache(final boolean isResultLevelCache) {
                return new Function<Object, Result<TopNResultValue>>(){
                    private final Granularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Result<TopNResultValue> apply(Object input) {
                        List results = (List)input;
                        ArrayList retVal = Lists.newArrayListWithCapacity((int)results.size());
                        Iterator inputIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)inputIter.next()).longValue());
                        while (inputIter.hasNext()) {
                            List result = (List)inputIter.next();
                            LinkedHashMap vals = Maps.newLinkedHashMap();
                            Iterator<Object> resultIter = result.iterator();
                            vals.put(query.getDimensionSpec().getOutputName(), DimensionHandlerUtils.convertObjectToType(resultIter.next(), (TypeSignature<ValueType>)query.getDimensionSpec().getOutputType()));
                            CacheStrategy.fetchAggregatorsFromCache(aggs, resultIter, isResultLevelCache, (aggName, aggPos, aggValueObject) -> vals.put(aggName, aggValueObject));
                            if (isResultLevelCache) {
                                Iterator<PostAggregator> postItr = query.getPostAggregatorSpecs().iterator();
                                while (postItr.hasNext() && resultIter.hasNext()) {
                                    vals.put(postItr.next().getName(), resultIter.next());
                                }
                            } else {
                                for (PostAggregator postAgg : postAggs) {
                                    vals.put(postAgg.getName(), postAgg.compute(vals));
                                }
                            }
                            retVal.add(vals);
                        }
                        return new Result<TopNResultValue>(timestamp, new TopNResultValue(retVal));
                    }
                };
            }
        };
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> preMergeQueryDecoration(QueryRunner<Result<TopNResultValue>> runner) {
        return (queryPlus, responseContext) -> {
            TopNQuery topNQuery = (TopNQuery)queryPlus.getQuery();
            if (TopNQueryEngine.canApplyExtractionInPost(topNQuery)) {
                DimensionSpec dimensionSpec = topNQuery.getDimensionSpec();
                QueryPlus<Result<TopNResultValue>> delegateQueryPlus = queryPlus.withQuery(topNQuery.withDimensionSpec(new DefaultDimensionSpec(dimensionSpec.getDimension(), dimensionSpec.getOutputName())));
                return runner.run(delegateQueryPlus, responseContext);
            }
            return runner.run(queryPlus.withQuery(topNQuery), responseContext);
        };
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> postMergeQueryDecoration(QueryRunner<Result<TopNResultValue>> runner) {
        final ThresholdAdjustingQueryRunner thresholdRunner = new ThresholdAdjustingQueryRunner(runner, this.config);
        return new QueryRunner<Result<TopNResultValue>>(){

            @Override
            public Sequence<Result<TopNResultValue>> run(QueryPlus<Result<TopNResultValue>> queryPlus, ResponseContext responseContext) {
                Sequence<Result<TopNResultValue>> resultSequence = thresholdRunner.run(queryPlus, responseContext);
                final TopNQuery topNQuery = (TopNQuery)queryPlus.getQuery();
                if (!TopNQueryEngine.canApplyExtractionInPost(topNQuery)) {
                    return resultSequence;
                }
                return Sequences.map(resultSequence, (Function)new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                    public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                        TopNResultValue resultValue = input.getValue();
                        return new Result<TopNResultValue>(input.getTimestamp(), new TopNResultValue(Lists.transform(resultValue.getValue(), (Function)new Function<DimensionAndMetricValueExtractor, DimensionAndMetricValueExtractor>(){

                            public DimensionAndMetricValueExtractor apply(DimensionAndMetricValueExtractor input) {
                                String dimOutputName = topNQuery.getDimensionSpec().getOutputName();
                                Object dimValue = input.getDimensionValue(dimOutputName);
                                Map<String, Object> map = input.getBaseObject();
                                map.put(dimOutputName, topNQuery.getDimensionSpec().getExtractionFn().apply(dimValue));
                                return input;
                            }
                        })));
                    }
                });
            }
        };
    }

    @Override
    public RowSignature resultArraySignature(TopNQuery query) {
        return RowSignature.builder().addTimeColumn().addDimensions(Collections.singletonList(query.getDimensionSpec())).addAggregators(query.getAggregatorSpecs(), RowSignature.Finalization.UNKNOWN).addPostAggregators(query.getPostAggregatorSpecs()).build();
    }

    @Override
    public Sequence<Object[]> resultsAsArrays(TopNQuery query, Sequence<Result<TopNResultValue>> resultSequence) {
        List<String> fields = this.resultArraySignature(query).getColumnNames();
        return resultSequence.flatMap(result -> {
            List<DimensionAndMetricValueExtractor> rows = ((TopNResultValue)result.getValue()).getValue();
            return Sequences.simple((Iterable)Iterables.transform(rows, row -> {
                Object[] retVal = new Object[fields.size()];
                retVal[0] = result.getTimestamp().getMillis();
                Map<String, Object> resultMap = row.getBaseObject();
                for (int i = 1; i < fields.size(); ++i) {
                    retVal[i] = resultMap.get(fields.get(i));
                }
                return retVal;
            }));
        });
    }

    static class ThresholdAdjustingQueryRunner
    implements QueryRunner<Result<TopNResultValue>> {
        private final QueryRunner<Result<TopNResultValue>> runner;
        private final TopNQueryConfig config;

        public ThresholdAdjustingQueryRunner(QueryRunner<Result<TopNResultValue>> runner, TopNQueryConfig config) {
            this.runner = runner;
            this.config = config;
        }

        @Override
        public Sequence<Result<TopNResultValue>> run(QueryPlus<Result<TopNResultValue>> queryPlus, ResponseContext responseContext) {
            Query<Result<TopNResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof TopNQuery)) {
                throw new ISE("Can only handle [%s], got [%s]", new Object[]{TopNQuery.class, input.getClass()});
            }
            final TopNQuery query = (TopNQuery)input;
            int minTopNThreshold = query.getContextValue("minTopNThreshold", this.config.getMinTopNThreshold());
            if (query.getThreshold() > minTopNThreshold) {
                return this.runner.run(queryPlus, responseContext);
            }
            final boolean isBySegment = QueryContexts.isBySegment(query);
            return Sequences.map(this.runner.run(queryPlus.withQuery(query.withThreshold(minTopNThreshold)), responseContext), (Function)new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                    if (isBySegment) {
                        BySegmentResultValue value = (BySegmentResultValue)((Object)input.getValue());
                        return new Result<TopNResultValue>(input.getTimestamp(), new BySegmentTopNResultValue(Lists.transform(value.getResults(), (Function)new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                            public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                                return new Result<TopNResultValue>(input.getTimestamp(), new TopNResultValue(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getThreshold()))));
                            }
                        }), value.getSegmentId(), value.getInterval()));
                    }
                    return new Result<TopNResultValue>(input.getTimestamp(), new TopNResultValue(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getThreshold()))));
                }
            });
        }
    }
}

