/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.guava.DelegatingYieldingAccumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.guava.YieldingSequenceBase;
import org.apache.druid.query.scan.ScanResultValue;

public class ScanQueryOffsetSequence
extends YieldingSequenceBase<ScanResultValue> {
    private final Sequence<ScanResultValue> baseSequence;
    private final long skip;

    public ScanQueryOffsetSequence(Sequence<ScanResultValue> baseSequence, long skip) {
        this.baseSequence = baseSequence;
        this.skip = skip;
        if (skip < 1L) {
            throw new IAE("'skip' must be greater than zero", new Object[0]);
        }
    }

    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, ScanResultValue> accumulator) {
        SkippingYieldingAccumulator<OutType> skippingAccumulator = new SkippingYieldingAccumulator<OutType>(accumulator);
        return this.wrapYielder(this.baseSequence.toYielder(initValue, skippingAccumulator), skippingAccumulator);
    }

    private <OutType> Yielder<OutType> wrapYielder(final Yielder<OutType> yielder, final SkippingYieldingAccumulator<OutType> accumulator) {
        return new Yielder<OutType>(){

            public OutType get() {
                return yielder.get();
            }

            public Yielder<OutType> next(OutType initValue) {
                return ScanQueryOffsetSequence.this.wrapYielder(yielder.next(initValue), accumulator);
            }

            public boolean isDone() {
                return yielder.isDone();
            }

            public void close() throws IOException {
                yielder.close();
            }
        };
    }

    private class SkippingYieldingAccumulator<OutType>
    extends DelegatingYieldingAccumulator<OutType, ScanResultValue> {
        private long skipped;

        public SkippingYieldingAccumulator(YieldingAccumulator<OutType, ScanResultValue> accumulator) {
            super(accumulator);
            this.skipped = 0L;
        }

        public OutType accumulate(OutType accumulated, ScanResultValue result) {
            if (this.skipped < ScanQueryOffsetSequence.this.skip) {
                List rows;
                long toSkip = ScanQueryOffsetSequence.this.skip - this.skipped;
                if (toSkip >= (long)(rows = (List)result.getEvents()).size()) {
                    this.skipped += (long)rows.size();
                    return accumulated;
                }
                List newEvents = rows.stream().skip(toSkip).collect(Collectors.toList());
                this.skipped += toSkip;
                return (OutType)super.accumulate(accumulated, (Object)new ScanResultValue(result.getSegmentId(), result.getColumns(), newEvents));
            }
            return (OutType)super.accumulate(accumulated, (Object)result);
        }
    }
}

