/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinPrefixUtils;
import org.apache.druid.segment.join.JoinType;

public class PreJoinableClause {
    private final String prefix;
    private final DataSource dataSource;
    private final JoinType joinType;
    private final JoinConditionAnalysis condition;

    public PreJoinableClause(String prefix, DataSource dataSource, JoinType joinType, JoinConditionAnalysis condition) {
        this.prefix = JoinPrefixUtils.validatePrefix(prefix);
        this.dataSource = (DataSource)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.joinType = (JoinType)((Object)Preconditions.checkNotNull((Object)((Object)joinType), (Object)"joinType"));
        this.condition = (JoinConditionAnalysis)Preconditions.checkNotNull((Object)condition, (Object)"condition");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public JoinConditionAnalysis getCondition() {
        return this.condition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreJoinableClause that = (PreJoinableClause)o;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.dataSource, that.dataSource) && this.joinType == that.joinType && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.dataSource, this.joinType, this.condition});
    }

    public String toString() {
        return "JoinClause{prefix='" + this.prefix + '\'' + ", dataSource=" + this.dataSource + ", joinType=" + (Object)((Object)this.joinType) + ", condition=" + this.condition + '}';
    }
}

