/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.LookupBean;

public class LookupSnapshotTaker {
    private static final Logger LOGGER = new Logger(LookupSnapshotTaker.class);
    private static final String PERSIST_FILE_SUFFIX = "lookupSnapshot.json";
    private final ObjectMapper objectMapper;
    private final File persistDirectory;

    public LookupSnapshotTaker(@Json ObjectMapper jsonMapper, String persistDirectory) {
        this.objectMapper = jsonMapper;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)persistDirectory) ? 1 : 0) != 0, (Object)"can not work without specifying persistDirectory");
        this.persistDirectory = new File(persistDirectory);
    }

    public synchronized List<LookupBean> pullExistingSnapshot(String tier) {
        File persistFile = this.getPersistFile(tier);
        try {
            if (!persistFile.isFile()) {
                LOGGER.warn("could not find any snapshot file under working directory [%s]", new Object[]{this.persistDirectory});
                return Collections.emptyList();
            }
            if (persistFile.length() == 0L) {
                LOGGER.warn("found empty file no lookups to load from [%s]", new Object[]{persistFile.getAbsolutePath()});
                return Collections.emptyList();
            }
            List lookupBeanList = (List)this.objectMapper.readValue(persistFile, (TypeReference)new TypeReference<List<LookupBean>>(){});
            return lookupBeanList;
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Exception during reading lookups from [%s]", new Object[]{persistFile.getAbsolutePath()});
        }
    }

    public synchronized void takeSnapshot(String tier, List<LookupBean> lookups) {
        File persistFile = this.getPersistFile(tier);
        try {
            FileUtils.writeAtomically((File)persistFile, out -> {
                this.objectMapper.writeValue(out, (Object)lookups);
                return null;
            });
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Exception during serialization of lookups using file [%s]", new Object[]{persistFile.getAbsolutePath()});
        }
    }

    @VisibleForTesting
    File getPersistFile(String tier) {
        return new File(this.persistDirectory, StringUtils.format((String)"%s.%s", (Object[])new Object[]{tier, PERSIST_FILE_SUFFIX}));
    }
}

