/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.IndexedInts;

public class StringGroupByColumnSelectorStrategy
implements GroupByColumnSelectorStrategy {
    @Nullable
    private final ColumnCapabilities capabilities;
    @Nullable
    private final IntFunction<String> dictionaryLookup;

    public StringGroupByColumnSelectorStrategy(IntFunction<String> dictionaryLookup, ColumnCapabilities capabilities) {
        this.dictionaryLookup = dictionaryLookup;
        this.capabilities = capabilities;
    }

    @Override
    public int getGroupingKeySize() {
        return 4;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
        int id = key.getInt(keyBufferPosition);
        if (id != -1) {
            resultRow.set(selectorPlus.getResultRowPosition(), ((DimensionSelector)selectorPlus.getSelector()).lookupName(id));
        } else {
            resultRow.set(selectorPlus.getResultRowPosition(), NullHandling.defaultStringValue());
        }
    }

    @Override
    public int initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        valuess[columnIndex] = row;
        return 0;
    }

    protected void writeToKeyBuffer(int keyBufferPosition, int dictId, ByteBuffer keyBuffer) {
        keyBuffer.putInt(keyBufferPosition, dictId);
    }

    @Override
    public int writeToKeyBuffer(int keyBufferPosition, ColumnValueSelector selector, ByteBuffer keyBuffer) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        Preconditions.checkState((row.size() < 2 ? 1 : 0) != 0, (Object)"Not supported for multi-value dimensions");
        int dictId = row.size() == 1 ? row.get(0) : -1;
        keyBuffer.putInt(keyBufferPosition, dictId);
        return 0;
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int dimensionIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        IndexedInts row = (IndexedInts)rowObj;
        int rowSize = row.size();
        this.initializeGroupingKeyV2Dimension(row, rowSize, keyBuffer, keyBufferPosition);
        stack[dimensionIndex] = rowSize == 0 ? 0 : 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        IndexedInts row = (IndexedInts)rowObj;
        int rowSize = row.size();
        if (rowValIdx < rowSize) {
            keyBuffer.putInt(keyBufferPosition, row.get(rowValIdx));
            return true;
        }
        return false;
    }

    private void initializeGroupingKeyV2Dimension(IndexedInts values, int rowSize, ByteBuffer keyBuffer, int keyBufferPosition) {
        if (rowSize == 0) {
            keyBuffer.putInt(keyBufferPosition, -1);
        } else {
            keyBuffer.putInt(keyBufferPosition, values.get(0));
        }
    }

    @Override
    public Grouper.BufferComparator bufferComparator(int keyBufferPosition, @Nullable StringComparator stringComparator) {
        StringComparator comparator;
        boolean canCompareInts = this.capabilities != null && this.capabilities.hasBitmapIndexes() && this.capabilities.areDictionaryValuesSorted().and(this.capabilities.areDictionaryValuesUnique()).isTrue();
        StringComparator stringComparator2 = comparator = stringComparator == null ? StringComparators.LEXICOGRAPHIC : stringComparator;
        if (canCompareInts && StringComparators.LEXICOGRAPHIC.equals(comparator)) {
            return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Integer.compare(lhsBuffer.getInt(lhsPosition + keyBufferPosition), rhsBuffer.getInt(rhsPosition + keyBufferPosition));
        }
        Preconditions.checkState((this.dictionaryLookup != null ? 1 : 0) != 0, (Object)"null dictionary lookup");
        return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
            String lhsStr = this.dictionaryLookup.apply(lhsBuffer.getInt(lhsPosition + keyBufferPosition));
            String rhsStr = this.dictionaryLookup.apply(rhsBuffer.getInt(rhsPosition + keyBufferPosition));
            return comparator.compare(lhsStr, rhsStr);
        };
    }

    @Override
    public void reset() {
    }
}

