/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import java.util.List;
import java.util.function.BinaryOperator;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.AllGranularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;

public class GroupByBinaryFnV2
implements BinaryOperator<ResultRow> {
    private final GroupByQuery query;

    public GroupByBinaryFnV2(GroupByQuery query) {
        this.query = query;
    }

    @Override
    @Nullable
    public ResultRow apply(@Nullable ResultRow arg1, @Nullable ResultRow arg2) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        ResultRow newResult = ResultRow.create(this.query.getResultRowSizeWithoutPostAggregators());
        if (this.query.getResultRowHasTimestamp()) {
            newResult.set(0, this.adjustTimestamp(arg1));
        }
        int dimensionStart = this.query.getResultRowDimensionStart();
        List<DimensionSpec> dimensions = this.query.getDimensions();
        for (int i = 0; i < dimensions.size(); ++i) {
            int rowIndex = dimensionStart + i;
            newResult.set(rowIndex, arg1.get(rowIndex));
        }
        int aggregatorStart = this.query.getResultRowAggregatorStart();
        List<AggregatorFactory> aggregatorSpecs = this.query.getAggregatorSpecs();
        for (int i = 0; i < aggregatorSpecs.size(); ++i) {
            AggregatorFactory aggregatorFactory = aggregatorSpecs.get(i);
            int rowIndex = aggregatorStart + i;
            newResult.set(rowIndex, aggregatorFactory.combine(arg1.get(rowIndex), arg2.get(rowIndex)));
        }
        return newResult;
    }

    private long adjustTimestamp(ResultRow row) {
        if (this.query.getGranularity() instanceof AllGranularity) {
            return row.getLong(0);
        }
        return this.query.getGranularity().bucketStart(row.getLong(0));
    }
}

