/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.ByteBufferHashTable;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.Groupers;
import org.apache.druid.query.groupby.epinephelinae.ReusableEntry;

public abstract class AbstractBufferHashGrouper<KeyType>
implements Grouper<KeyType> {
    protected static final int HASH_SIZE = 4;
    protected static final Logger log = new Logger(AbstractBufferHashGrouper.class);
    protected final Supplier<ByteBuffer> bufferSupplier;
    protected final Grouper.KeySerde<KeyType> keySerde;
    protected final int keySize;
    protected final AggregatorAdapters aggregators;
    protected final int baseAggregatorOffset;
    protected final int bufferGrouperMaxSize;
    protected float maxLoadFactor;
    protected int initialBuckets;
    protected int bucketSize;
    protected ByteBufferHashTable hashTable;
    protected ByteBuffer hashTableBuffer;

    public AbstractBufferHashGrouper(Supplier<ByteBuffer> bufferSupplier, Grouper.KeySerde<KeyType> keySerde, AggregatorAdapters aggregators, int baseAggregatorOffset, int bufferGrouperMaxSize) {
        this.bufferSupplier = bufferSupplier;
        this.keySerde = keySerde;
        this.keySize = keySerde.keySize();
        this.aggregators = aggregators;
        this.baseAggregatorOffset = baseAggregatorOffset;
        this.bufferGrouperMaxSize = bufferGrouperMaxSize;
    }

    public abstract void newBucketHook(int var1);

    public abstract boolean canSkipAggregate(int var1);

    public abstract void afterAggregateHook(int var1);

    public int getGrowthCount() {
        return this.hashTable.getGrowthCount();
    }

    public int getSize() {
        return this.hashTable.getSize();
    }

    public int getBuckets() {
        return this.hashTable.getMaxBuckets();
    }

    public int getMaxSize() {
        return this.hashTable.getRegrowthThreshold();
    }

    @Override
    public AggregateResult aggregate(KeyType key, int keyHash) {
        ByteBuffer keyBuffer = this.keySerde.toByteBuffer(key);
        if (keyBuffer == null) {
            return Groupers.dictionaryFull(0);
        }
        if (keyBuffer.remaining() != this.keySize) {
            throw new IAE("keySerde.toByteBuffer(key).remaining[%s] != keySerde.keySize[%s], buffer was the wrong size?!", new Object[]{keyBuffer.remaining(), this.keySize});
        }
        int bucket = this.hashTable.findBucketWithAutoGrowth(keyBuffer, keyHash, () -> {});
        if (bucket < 0) {
            return Groupers.hashTableFull(0);
        }
        int bucketStartOffset = this.hashTable.getOffsetForBucket(bucket);
        boolean bucketWasUsed = this.hashTable.isBucketUsed(bucket);
        ByteBuffer tableBuffer = this.hashTable.getTableBuffer();
        if (!bucketWasUsed) {
            this.hashTable.initializeNewBucketKey(bucket, keyBuffer, keyHash);
            this.aggregators.init(tableBuffer, bucketStartOffset + this.baseAggregatorOffset);
            this.newBucketHook(bucketStartOffset);
        }
        if (this.canSkipAggregate(bucketStartOffset)) {
            return AggregateResult.ok();
        }
        this.aggregators.aggregateBuffered(tableBuffer, bucketStartOffset + this.baseAggregatorOffset);
        this.afterAggregateHook(bucketStartOffset);
        return AggregateResult.ok();
    }

    @Override
    public void close() {
        this.aggregators.close();
    }

    protected Grouper.Entry<KeyType> populateBucketEntryForOffset(ReusableEntry<KeyType> reusableEntry, int bucketOffset) {
        ByteBuffer tableBuffer = this.hashTable.getTableBuffer();
        this.keySerde.readFromByteBuffer(reusableEntry.getKey(), tableBuffer, bucketOffset + 4);
        if (reusableEntry.getValues().length != this.aggregators.size()) {
            throw new ISE("Expected entry with [%d] values but got [%d]", new Object[]{this.aggregators.size(), reusableEntry.getValues().length});
        }
        for (int i = 0; i < this.aggregators.size(); ++i) {
            reusableEntry.getValues()[i] = this.aggregators.get(tableBuffer, bucketOffset + this.baseAggregatorOffset, i);
        }
        return reusableEntry;
    }
}

