/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RangeSet;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Chars;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.segment.filter.LikeFilter;

public class LikeDimFilter
extends AbstractOptimizableDimFilter
implements DimFilter {
    private static final Pattern DEFINITELY_FINE = Pattern.compile("[\\w\\d\\s-]");
    private static final String WILDCARD = ".*";
    private final String dimension;
    private final String pattern;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final ExtractionFn extractionFn;
    @Nullable
    private final FilterTuning filterTuning;
    private final LikeMatcher likeMatcher;

    @JsonCreator
    public LikeDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="pattern") String pattern, @JsonProperty(value="escape") @Nullable String escape, @JsonProperty(value="extractionFn") @Nullable ExtractionFn extractionFn, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        this.pattern = (String)Preconditions.checkNotNull((Object)pattern, (Object)"pattern");
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
        if (escape != null && escape.length() != 1) {
            throw new IllegalArgumentException("Escape must be null or a single character");
        }
        this.escapeChar = escape == null || escape.isEmpty() ? null : Character.valueOf(escape.charAt(0));
        this.likeMatcher = LikeMatcher.from(pattern, this.escapeChar);
    }

    @VisibleForTesting
    public LikeDimFilter(String dimension, String pattern, @Nullable String escape, @Nullable ExtractionFn extractionFn) {
        this(dimension, pattern, escape, extractionFn, null);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    @JsonProperty
    public String getEscape() {
        return this.escapeChar != null ? this.escapeChar.toString() : null;
    }

    @Nullable
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] patternBytes = StringUtils.toUtf8((String)this.pattern);
        byte[] escapeBytes = this.escapeChar == null ? new byte[]{} : Chars.toByteArray((char)this.escapeChar.charValue());
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        int sz = 4 + dimensionBytes.length + patternBytes.length + escapeBytes.length + extractionFnBytes.length;
        return ByteBuffer.allocate(sz).put((byte)12).put(dimensionBytes).put((byte)-1).put(patternBytes).put((byte)-1).put(escapeBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new LikeFilter(this.dimension, this.extractionFn, this.likeMatcher, this.filterTuning);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikeDimFilter that = (LikeDimFilter)o;
        return this.dimension.equals(that.dimension) && this.pattern.equals(that.pattern) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.pattern, this.escapeChar, this.extractionFn, this.filterTuning);
    }

    public String toString() {
        DimFilter.DimFilterToStringBuilder builder = new DimFilter.DimFilterToStringBuilder();
        builder.appendDimension(this.dimension, this.extractionFn).append(" LIKE '").append(this.pattern).append("'");
        if (this.escapeChar != null) {
            builder.append(" ESCAPE '").append(this.escapeChar).append("'");
        }
        return builder.appendFilterTuning(this.filterTuning).build();
    }

    public static class LikeMatcher {
        private final SuffixMatch suffixMatch;
        private final String prefix;
        private final Pattern pattern;

        private LikeMatcher(SuffixMatch suffixMatch, String prefix, Pattern pattern) {
            this.suffixMatch = (SuffixMatch)((Object)Preconditions.checkNotNull((Object)((Object)suffixMatch), (Object)"suffixMatch"));
            this.prefix = NullHandling.nullToEmptyIfNeeded((String)prefix);
            this.pattern = (Pattern)Preconditions.checkNotNull((Object)pattern, (Object)"pattern");
        }

        public static LikeMatcher from(String likePattern, @Nullable Character escapeChar) {
            StringBuilder prefix = new StringBuilder();
            StringBuilder regex = new StringBuilder();
            boolean escaping = false;
            boolean inPrefix = true;
            SuffixMatch suffixMatch = SuffixMatch.MATCH_EMPTY;
            for (int i = 0; i < likePattern.length(); ++i) {
                char c = likePattern.charAt(i);
                if (escapeChar != null && c == escapeChar.charValue() && !escaping) {
                    escaping = true;
                    continue;
                }
                if (c == '%' && !escaping) {
                    inPrefix = false;
                    if (suffixMatch == SuffixMatch.MATCH_EMPTY) {
                        suffixMatch = SuffixMatch.MATCH_ANY;
                    }
                    regex.append(LikeDimFilter.WILDCARD);
                    continue;
                }
                if (c == '_' && !escaping) {
                    inPrefix = false;
                    suffixMatch = SuffixMatch.MATCH_PATTERN;
                    regex.append(".");
                    continue;
                }
                if (inPrefix) {
                    prefix.append(c);
                } else {
                    suffixMatch = SuffixMatch.MATCH_PATTERN;
                }
                LikeMatcher.addPatternCharacter(regex, c);
                escaping = false;
            }
            return new LikeMatcher(suffixMatch, prefix.toString(), Pattern.compile(regex.toString(), 32));
        }

        private static void addPatternCharacter(StringBuilder patternBuilder, char c) {
            if (DEFINITELY_FINE.matcher(String.valueOf(c)).matches()) {
                patternBuilder.append(c);
            } else {
                patternBuilder.append("\\u").append(BaseEncoding.base16().encode(Chars.toByteArray((char)c)));
            }
        }

        public boolean matches(@Nullable String s) {
            return LikeMatcher.matches(s, this.pattern);
        }

        private static boolean matches(@Nullable String s, Pattern pattern) {
            String val = NullHandling.nullToEmptyIfNeeded((String)s);
            return val != null && pattern.matcher(val).matches();
        }

        public boolean matchesSuffixOnly(@Nullable String value) {
            if (this.suffixMatch == SuffixMatch.MATCH_ANY) {
                return true;
            }
            if (this.suffixMatch == SuffixMatch.MATCH_EMPTY) {
                return value == null ? this.matches(null) : value.length() == this.prefix.length();
            }
            return this.matches(value);
        }

        public DruidPredicateFactory predicateFactory(ExtractionFn extractionFn) {
            return new PatternDruidPredicateFactory(extractionFn, this.pattern);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public SuffixMatch getSuffixMatch() {
            return this.suffixMatch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LikeMatcher that = (LikeMatcher)o;
            return this.getSuffixMatch() == that.getSuffixMatch() && Objects.equals(this.getPrefix(), that.getPrefix()) && Objects.equals(this.pattern.toString(), that.pattern.toString());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getSuffixMatch(), this.getPrefix(), this.pattern.toString()});
        }

        @VisibleForTesting
        static class PatternDruidPredicateFactory
        implements DruidPredicateFactory {
            private final ExtractionFn extractionFn;
            private final Pattern pattern;

            PatternDruidPredicateFactory(ExtractionFn extractionFn, Pattern pattern) {
                this.extractionFn = extractionFn;
                this.pattern = pattern;
            }

            @Override
            public Predicate<String> makeStringPredicate() {
                if (this.extractionFn != null) {
                    return input -> LikeMatcher.matches(this.extractionFn.apply((String)input), this.pattern);
                }
                return input -> LikeMatcher.matches(input, this.pattern);
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                if (this.extractionFn != null) {
                    return input -> LikeMatcher.matches(this.extractionFn.apply(input), this.pattern);
                }
                return input -> LikeMatcher.matches(String.valueOf(input), this.pattern);
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                if (this.extractionFn != null) {
                    return input -> LikeMatcher.matches(this.extractionFn.apply(Float.valueOf(input)), this.pattern);
                }
                return input -> LikeMatcher.matches(String.valueOf(input), this.pattern);
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                if (this.extractionFn != null) {
                    return input -> LikeMatcher.matches(this.extractionFn.apply(input), this.pattern);
                }
                return input -> LikeMatcher.matches(String.valueOf(input), this.pattern);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PatternDruidPredicateFactory that = (PatternDruidPredicateFactory)o;
                return Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.pattern.toString(), that.pattern.toString());
            }

            public int hashCode() {
                return Objects.hash(this.extractionFn, this.pattern.toString());
            }
        }

        public static enum SuffixMatch {
            MATCH_ANY,
            MATCH_EMPTY,
            MATCH_PATTERN;

        }
    }
}

