/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.last.NumericLastVectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleLastVectorAggregator
extends NumericLastVectorAggregator {
    double lastValue = 0.0;

    public DoubleLastVectorAggregator(VectorValueSelector timeSelector, VectorValueSelector valueSelector) {
        super(timeSelector, valueSelector);
    }

    @Override
    void putValue(ByteBuffer buf, int position, int index) {
        this.lastValue = this.valueSelector.getDoubleVector()[index];
        buf.putDouble(position, this.lastValue);
    }

    @Override
    public void initValue(ByteBuffer buf, int position) {
        buf.putDouble(position, 0.0);
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePair((Object)buf.getLong(position), rhsNull ? null : Double.valueOf(buf.getDouble(position + 9)));
    }
}

