/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.first.StringFirstLastUtils;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class StringFirstAggregator
implements Aggregator {
    private final BaseLongColumnValueSelector timeSelector;
    private final BaseObjectColumnValueSelector<?> valueSelector;
    private final int maxStringBytes;
    private final boolean needsFoldCheck;
    protected long firstTime;
    protected String firstValue;

    public StringFirstAggregator(BaseLongColumnValueSelector timeSelector, BaseObjectColumnValueSelector<?> valueSelector, int maxStringBytes, boolean needsFoldCheck) {
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.maxStringBytes = maxStringBytes;
        this.needsFoldCheck = needsFoldCheck;
        this.firstTime = DateTimes.MAX.getMillis();
        this.firstValue = null;
    }

    @Override
    public void aggregate() {
        if (this.timeSelector.isNull()) {
            return;
        }
        if (this.needsFoldCheck) {
            SerializablePairLongString inPair = StringFirstLastUtils.readPairFromSelectors(this.timeSelector, this.valueSelector);
            if (inPair != null && (Long)inPair.lhs < this.firstTime) {
                this.firstTime = (Long)inPair.lhs;
                this.firstValue = StringUtils.fastLooseChop((String)((String)inPair.rhs), (int)this.maxStringBytes);
            }
        } else {
            long time = this.timeSelector.getLong();
            if (time < this.firstTime) {
                String value = DimensionHandlerUtils.convertObjectToString(this.valueSelector.getObject());
                this.firstTime = time;
                this.firstValue = StringUtils.fastLooseChop((String)value, (int)this.maxStringBytes);
            }
        }
    }

    @Override
    public Object get() {
        return new SerializablePairLongString(this.firstTime, StringUtils.chop((String)this.firstValue, (int)this.maxStringBytes));
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getLong()");
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }
}

