/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;

public class StringAnyVectorAggregator
implements VectorAggregator {
    private static final int FOUND_AND_NULL_FLAG_VALUE = -1;
    @VisibleForTesting
    static final int NOT_FOUND_FLAG_VALUE = -2;
    @VisibleForTesting
    static final int FOUND_VALUE_OFFSET = 4;
    @Nullable
    private final SingleValueDimensionVectorSelector singleValueSelector;
    @Nullable
    private final MultiValueDimensionVectorSelector multiValueSelector;
    private final int maxStringBytes;

    public StringAnyVectorAggregator(SingleValueDimensionVectorSelector singleValueSelector, MultiValueDimensionVectorSelector multiValueSelector, int maxStringBytes) {
        Preconditions.checkState((singleValueSelector != null || multiValueSelector != null ? 1 : 0) != 0, (Object)"At least one selector must be non null");
        Preconditions.checkState((singleValueSelector == null || multiValueSelector == null ? 1 : 0) != 0, (Object)"Only one selector must be non null");
        this.multiValueSelector = multiValueSelector;
        this.singleValueSelector = singleValueSelector;
        this.maxStringBytes = maxStringBytes;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putInt(position, -2);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        if (buf.getInt(position) == -2 && startRow < endRow) {
            int[] rows;
            if (this.multiValueSelector != null) {
                IndexedInts[] rows2 = this.multiValueSelector.getRowVector();
                if (startRow < rows2.length) {
                    IndexedInts row = rows2[startRow];
                    String foundValue = row.size() == 0 ? null : this.multiValueSelector.lookupName(row.get(0));
                    this.putValue(buf, position, foundValue);
                }
            } else if (this.singleValueSelector != null && startRow < (rows = this.singleValueSelector.getRowVector()).length) {
                int row = rows[startRow];
                String foundValue = this.singleValueSelector.lookupName(row);
                this.putValue(buf, position, foundValue);
            }
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        for (int i = 0; i < numRows; ++i) {
            int position = positions[i] + positionOffset;
            int row = rows == null ? i : rows[i];
            this.aggregate(buf, position, row, row + 1);
        }
    }

    @Override
    @Nullable
    public String get(ByteBuffer buf, int position) {
        ByteBuffer copyBuffer = buf.duplicate();
        copyBuffer.position(position);
        int stringSizeBytes = copyBuffer.getInt();
        if (stringSizeBytes >= 0) {
            byte[] valueBytes = new byte[stringSizeBytes];
            copyBuffer.get(valueBytes, 0, stringSizeBytes);
            return StringUtils.fromUtf8((byte[])valueBytes);
        }
        return null;
    }

    @Override
    public void close() {
    }

    private void putValue(ByteBuffer buf, int position, @Nullable String foundValue) {
        if (foundValue != null) {
            ByteBuffer mutationBuffer = buf.duplicate();
            mutationBuffer.position(position + 4);
            mutationBuffer.limit(position + 4 + this.maxStringBytes);
            int len = StringUtils.toUtf8WithLimit((String)foundValue, (ByteBuffer)mutationBuffer);
            mutationBuffer.putInt(position, len);
        } else {
            buf.putInt(position, -1);
        }
    }
}

