/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;

public class Queries {
    public static List<PostAggregator> decoratePostAggregators(List<PostAggregator> postAggs, Map<String, AggregatorFactory> aggFactories) {
        ArrayList decorated = Lists.newArrayListWithExpectedSize((int)postAggs.size());
        for (PostAggregator aggregator : postAggs) {
            decorated.add(aggregator.decorate(aggFactories));
        }
        return decorated;
    }

    @Deprecated
    public static List<PostAggregator> prepareAggregations(List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        return Queries.prepareAggregations(Collections.emptyList(), aggFactories, postAggs);
    }

    public static List<PostAggregator> prepareAggregations(List<String> otherOutputNames, List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        Preconditions.checkNotNull(otherOutputNames, (Object)"otherOutputNames cannot be null");
        Preconditions.checkNotNull(aggFactories, (Object)"aggregations cannot be null");
        HashSet<String> combinedOutputNames = new HashSet<String>(otherOutputNames);
        HashMap<String, AggregatorFactory> aggsFactoryMap = new HashMap<String, AggregatorFactory>();
        for (AggregatorFactory aggFactory : aggFactories) {
            Preconditions.checkArgument((boolean)combinedOutputNames.add(aggFactory.getName()), (String)"[%s] already defined", (Object[])new Object[]{aggFactory.getName()});
            aggsFactoryMap.put(aggFactory.getName(), aggFactory);
        }
        if (postAggs != null && !postAggs.isEmpty()) {
            ArrayList decorated = Lists.newArrayListWithExpectedSize((int)postAggs.size());
            for (PostAggregator postAgg : postAggs) {
                Set<String> dependencies = postAgg.getDependentFields();
                Sets.SetView missing = Sets.difference(dependencies, combinedOutputNames);
                Preconditions.checkArgument((boolean)missing.isEmpty(), (String)"Missing fields [%s] for postAggregator [%s]", (Object[])new Object[]{missing, postAgg.getName()});
                Preconditions.checkArgument((boolean)combinedOutputNames.add(postAgg.getName()), (String)"[%s] already defined", (Object[])new Object[]{postAgg.getName()});
                decorated.add(postAgg.decorate(aggsFactoryMap));
            }
            return decorated;
        }
        return postAggs;
    }

    public static <T> Query<T> withSpecificSegments(Query<T> query, List<SegmentDescriptor> descriptors) {
        Query<T> retVal;
        if (query.getDataSource() instanceof QueryDataSource) {
            Query subQuery = ((QueryDataSource)query.getDataSource()).getQuery();
            retVal = query.withDataSource(new QueryDataSource(Queries.withSpecificSegments(subQuery, descriptors)));
        } else {
            retVal = query.withQuerySegmentSpec(new MultipleSpecificSegmentSpec(descriptors));
        }
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource(retVal.getDataSource());
        if (!analysis.getBaseTableDataSource().isPresent()) {
            throw new ISE("Unable to apply specific segments to non-table-based dataSource[%s]", new Object[]{query.getDataSource()});
        }
        if (analysis.getBaseQuerySegmentSpec().isPresent() && !analysis.getBaseQuerySegmentSpec().get().equals(new MultipleSpecificSegmentSpec(descriptors))) {
            throw new ISE("Unable to apply specific segments to query with dataSource[%s]", new Object[]{query.getDataSource()});
        }
        return retVal;
    }

    public static <T> Query<T> withBaseDataSource(Query<T> query, DataSource newBaseDataSource) {
        DataSourceAnalysis analysis;
        Query<T> retVal;
        if (query.getDataSource() instanceof QueryDataSource) {
            Query subQuery = ((QueryDataSource)query.getDataSource()).getQuery();
            retVal = query.withDataSource(new QueryDataSource(Queries.withBaseDataSource(subQuery, newBaseDataSource)));
        } else {
            analysis = DataSourceAnalysis.forDataSource(query.getDataSource());
            DataSource current = newBaseDataSource;
            DimFilter joinBaseFilter = analysis.getJoinBaseTableFilter().orElse(null);
            for (PreJoinableClause clause : analysis.getPreJoinableClauses()) {
                current = JoinDataSource.create(current, clause.getDataSource(), clause.getPrefix(), clause.getCondition(), clause.getJoinType(), joinBaseFilter);
                joinBaseFilter = null;
            }
            retVal = query.withDataSource(current);
        }
        analysis = DataSourceAnalysis.forDataSource(retVal.getDataSource());
        if (!newBaseDataSource.equals(analysis.getBaseDataSource())) {
            throw new ISE("Unable to replace base dataSource", new Object[0]);
        }
        return retVal;
    }

    public static Set<String> computeRequiredColumns(VirtualColumns virtualColumns, @Nullable DimFilter filter, List<DimensionSpec> dimensions, List<AggregatorFactory> aggregators, List<String> additionalColumns) {
        HashSet<String> requiredColumns = new HashSet<String>();
        requiredColumns.add("__time");
        for (VirtualColumn virtualColumn : virtualColumns.getVirtualColumns()) {
            for (String column : virtualColumn.requiredColumns()) {
                if (virtualColumns.exists(column)) continue;
                requiredColumns.addAll(virtualColumn.requiredColumns());
            }
        }
        if (filter != null) {
            for (String column : filter.getRequiredColumns()) {
                if (virtualColumns.exists(column)) continue;
                requiredColumns.add(column);
            }
        }
        for (DimensionSpec dimensionSpec : dimensions) {
            if (virtualColumns.exists(dimensionSpec.getDimension())) continue;
            requiredColumns.add(dimensionSpec.getDimension());
        }
        for (AggregatorFactory aggregator : aggregators) {
            for (String column : aggregator.requiredFields()) {
                if (virtualColumns.exists(column)) continue;
                requiredColumns.add(column);
            }
        }
        for (String column : additionalColumns) {
            if (virtualColumns.exists(column)) continue;
            requiredColumns.add(column);
        }
        return requiredColumns;
    }
}

