/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.frame.write.columnar.FrameColumnWriter;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class LongFrameColumnWriter
implements FrameColumnWriter {
    public static final long DATA_OFFSET = 2L;
    private final BaseLongColumnValueSelector selector;
    private final AppendableMemory appendableMemory;
    private final boolean hasNulls;
    private final int sz;

    LongFrameColumnWriter(BaseLongColumnValueSelector selector, MemoryAllocator allocator, boolean hasNulls) {
        this.selector = selector;
        this.appendableMemory = AppendableMemory.create(allocator);
        this.hasNulls = hasNulls;
        this.sz = LongFrameColumnWriter.valueSize(hasNulls);
    }

    public static int valueSize(boolean hasNulls) {
        return hasNulls ? 9 : 8;
    }

    @Override
    public boolean addSelection() {
        if (!this.appendableMemory.reserveAdditional(this.sz)) {
            return false;
        }
        MemoryRange<WritableMemory> cursor = this.appendableMemory.cursor();
        WritableMemory memory = cursor.memory();
        long position = cursor.start();
        if (this.hasNulls) {
            if (this.selector.isNull()) {
                memory.putByte(position, (byte)1);
                memory.putLong(position + 1L, 0L);
            } else {
                memory.putByte(position, (byte)0);
                memory.putLong(position + 1L, this.selector.getLong());
            }
        } else {
            memory.putLong(position, this.selector.getLong());
        }
        this.appendableMemory.advanceCursor(this.sz);
        return true;
    }

    @Override
    public void undo() {
        this.appendableMemory.rewindCursor(this.sz);
    }

    @Override
    public long size() {
        return 2L + this.appendableMemory.size();
    }

    @Override
    public long writeTo(WritableMemory memory, long startPosition) {
        long currentPosition = startPosition;
        memory.putByte(currentPosition, (byte)1);
        memory.putByte(currentPosition + 1L, this.hasNulls ? (byte)1 : 0);
        currentPosition += 2L;
        currentPosition += this.appendableMemory.writeTo(memory, currentPosition);
        return currentPosition - startPosition;
    }

    @Override
    public void close() {
        this.appendableMemory.close();
    }
}

