/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import com.google.common.primitives.Ints;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.columnar.ColumnPlus;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

public class ComplexFrameColumnReader
implements FrameColumnReader {
    private final int columnNumber;

    ComplexFrameColumnReader(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public ColumnPlus readColumn(Frame frame) {
        Memory memory = frame.region(this.columnNumber);
        this.validate(memory, frame.numRows());
        int typeNameLength = memory.getInt(1L);
        byte[] typeNameBytes = new byte[typeNameLength];
        memory.getByteArray(5L, typeNameBytes, 0, typeNameLength);
        String typeName = StringUtils.fromUtf8((byte[])typeNameBytes);
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
        if (serde == null) {
            throw new ISE("Cannot read column with complexTypeName[%s]", new Object[]{typeName});
        }
        long startOfOffsetSection = 5 + typeNameLength;
        long startOfDataSection = startOfOffsetSection + (long)frame.numRows() * 4L;
        return new ColumnPlus(new ComplexFrameColumn(frame, serde, memory, startOfOffsetSection, startOfDataSection), new ColumnCapabilitiesImpl().setType(ColumnType.ofComplex((String)typeName)).setHasMultipleValues(false), frame.numRows());
    }

    private void validate(Memory region, int numRows) {
        if (region.getCapacity() < 5L) {
            throw new ISE("Column is not big enough for a header", new Object[0]);
        }
        byte typeCode = region.getByte(0L);
        if (typeCode != 5) {
            throw new ISE("Column does not have the correct type code", new Object[0]);
        }
        int typeNameLength = region.getInt(1L);
        if (region.getCapacity() < (long)(5 + typeNameLength) + (long)numRows * 4L) {
            throw new ISE("Column is missing offset section", new Object[0]);
        }
    }

    private static class ComplexFrameColumn
    implements ComplexColumn {
        private final Frame frame;
        private final ComplexMetricSerde serde;
        private final Memory memory;
        private final long startOfOffsetSection;
        private final long startOfDataSection;

        private ComplexFrameColumn(Frame frame, ComplexMetricSerde serde, Memory memory, long startOfOffsetSection, long startOfDataSection) {
            this.frame = frame;
            this.serde = serde;
            this.memory = memory;
            this.startOfOffsetSection = startOfOffsetSection;
            this.startOfDataSection = startOfDataSection;
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
            return new ObjectColumnSelector<Object>(){

                @Override
                @Nullable
                public Object getObject() {
                    return this.getObjectForPhysicalRow(frame.physicalRow(offset.getOffset()));
                }

                @Override
                public Class<?> classOfObject() {
                    return serde.getExtractor().extractedClass();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            };
        }

        @Override
        public Class<?> getClazz() {
            return this.serde.getClass();
        }

        @Override
        public String getTypeName() {
            return this.serde.getTypeName();
        }

        @Override
        public Object getRowValue(int rowNum) {
            if (rowNum < 0 || rowNum >= this.frame.numRows()) {
                throw new ISE("Row [%d] out of bounds", new Object[]{rowNum});
            }
            return this.getObjectForPhysicalRow(this.frame.physicalRow(rowNum));
        }

        @Override
        public int getLength() {
            return this.frame.numRows();
        }

        @Override
        public void close() {
        }

        @Nullable
        private Object getObjectForPhysicalRow(int physicalRow) {
            long endOffset = this.startOfDataSection + (long)this.memory.getInt(this.startOfOffsetSection + 4L * (long)physicalRow);
            long startOffset = physicalRow == 0 ? this.startOfDataSection : this.startOfDataSection + (long)this.memory.getInt(this.startOfOffsetSection + 4L * (long)(physicalRow - 1));
            if (this.memory.getByte(startOffset) == 1) {
                return null;
            }
            int payloadLength = Ints.checkedCast((long)(endOffset - startOffset - 1L));
            byte[] complexBytes = new byte[payloadLength];
            this.memory.getByteArray(startOffset + 1L, complexBytes, 0, payloadLength);
            return this.serde.fromBytes(complexBytes, 0, complexBytes.length);
        }
    }
}

