/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;

public class FrameReaderUtils {
    public static ByteBuffer readByteBuffer(Memory memory, long dataStart, int dataLength) {
        if (memory.hasByteBuffer()) {
            ByteBuffer byteBuffer = memory.getByteBuffer().duplicate();
            byteBuffer.limit(Ints.checkedCast((long)memory.getRegionOffset(dataStart + (long)dataLength)));
            byteBuffer.position(Ints.checkedCast((long)memory.getRegionOffset(dataStart)));
            return byteBuffer;
        }
        byte[] stringData = new byte[dataLength];
        memory.getByteArray(dataStart, stringData, 0, stringData.length);
        return ByteBuffer.wrap(stringData);
    }

    @Nullable
    public static Supplier<MemoryRange<Memory>> makeRowMemorySupplier(ColumnSelectorFactory columnSelectorFactory, final RowSignature expectedSignature) {
        if (FrameReaderUtils.mayBeAbleToSelectRowMemory(columnSelectorFactory)) {
            final ColumnValueSelector signatureSelector = columnSelectorFactory.makeColumnValueSelector("___druid_frame_row_signature");
            final ColumnValueSelector memorySelector = columnSelectorFactory.makeColumnValueSelector("___druid_frame_row_mem");
            return new Supplier<MemoryRange<Memory>>(){
                private RowSignature lastSignature = null;
                private boolean lastSignatureOk = false;

                @Override
                public MemoryRange<Memory> get() {
                    RowSignature selectedSignature = (RowSignature)signatureSelector.getObject();
                    if (selectedSignature != this.lastSignature) {
                        this.lastSignature = selectedSignature;
                        this.lastSignatureOk = expectedSignature.equals(selectedSignature);
                    }
                    if (this.lastSignatureOk) {
                        return (MemoryRange)memorySelector.getObject();
                    }
                    return null;
                }
            };
        }
        return null;
    }

    public static int compareMemoryUnsigned(Memory memory1, long position1, long length1, Memory memory2, long position2, long length2) {
        long commonLength = Math.min(length1, length2);
        for (long i = 0L; i < commonLength; ++i) {
            byte byte2;
            byte byte1 = memory1.getByte(position1 + i);
            int cmp = (byte1 & 0xFF) - ((byte2 = memory2.getByte(position2 + i)) & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return Long.compare(length1, length2);
    }

    public static int compareMemoryToByteArrayUnsigned(Memory memory, long position1, long length1, byte[] array, int position2, int length2) {
        int commonLength = (int)Math.min(length1, (long)length2);
        for (int i = 0; i < commonLength; ++i) {
            byte byte2;
            byte byte1 = memory.getByte(position1 + (long)i);
            int cmp = (byte1 & 0xFF) - ((byte2 = array[position2 + i]) & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return Long.compare(length1, length2);
    }

    public static int compareByteArraysUnsigned(byte[] array1, int position1, int length1, byte[] array2, int position2, int length2) {
        int commonLength = Math.min(length1, length2);
        for (int i = 0; i < commonLength; ++i) {
            byte byte1 = array1[position1 + i];
            byte byte2 = array2[position2 + i];
            int cmp = (byte1 & 0xFF) - (byte2 & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(length1, length2);
    }

    private static boolean mayBeAbleToSelectRowMemory(ColumnSelectorFactory columnSelectorFactory) {
        ColumnCapabilities rowSignatureCapabilities = columnSelectorFactory.getColumnCapabilities("___druid_frame_row_signature");
        if (rowSignatureCapabilities == null || rowSignatureCapabilities.getType() != ValueType.COMPLEX) {
            return false;
        }
        ColumnCapabilities rowMemoryCapabilities = columnSelectorFactory.getColumnCapabilities("___druid_frame_row_mem");
        return rowMemoryCapabilities != null && rowMemoryCapabilities.getType() == ValueType.COMPLEX;
    }
}

