/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.processor.Bouncer;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessorExecutor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.logger.Logger;

public class RunAllFullyWidget<T, ResultType> {
    private static final Logger log = new Logger(RunAllFullyWidget.class);
    private final Sequence<? extends FrameProcessor<T>> processors;
    private final FrameProcessorExecutor exec;
    private final ResultType initialResult;
    private final BiFunction<ResultType, T, ResultType> accumulateFn;
    private final int maxOutstandingProcessors;
    private final Bouncer bouncer;
    @Nullable
    private final String cancellationId;

    RunAllFullyWidget(Sequence<? extends FrameProcessor<T>> processors, FrameProcessorExecutor exec, ResultType initialResult, BiFunction<ResultType, T, ResultType> accumulateFn, int maxOutstandingProcessors, Bouncer bouncer, @Nullable String cancellationId) {
        this.processors = processors;
        this.exec = exec;
        this.initialResult = initialResult;
        this.accumulateFn = accumulateFn;
        this.maxOutstandingProcessors = maxOutstandingProcessors;
        this.bouncer = bouncer;
        this.cancellationId = cancellationId;
    }

    ListenableFuture<ResultType> run() {
        Yielder processorYielder;
        try {
            processorYielder = Yielders.each(this.processors);
        }
        catch (Throwable e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        if (processorYielder.isDone()) {
            return Futures.immediateFuture(this.initialResult);
        }
        RunAllFullyRunnable runnable = new RunAllFullyRunnable(processorYielder);
        for (int i = 0; i < this.maxOutstandingProcessors; ++i) {
            this.exec.getExecutorService().submit((Runnable)runnable);
        }
        return runnable.finishedFuture;
    }

    private class RunAllFullyRunnable
    implements Runnable {
        private final AtomicReference<Either<Throwable, ResultType>> finished = new AtomicReference();
        private final SettableFuture<ResultType> finishedFuture;
        private final Object runAllFullyLock = new Object();
        @GuardedBy(value="runAllFullyLock")
        Yielder<? extends FrameProcessor<T>> processorYielder;
        @GuardedBy(value="runAllFullyLock")
        ResultType currentResult = null;
        @GuardedBy(value="runAllFullyLock")
        boolean seenFirstResult = false;
        @GuardedBy(value="runAllFullyLock")
        int outstandingProcessors = 0;
        @GuardedBy(value="runAllFullyLock")
        Set<ListenableFuture<?>> outstandingFutures = Collections.newSetFromMap(new IdentityHashMap());
        @Nullable
        @GuardedBy(value="runAllFullyLock")
        Queue<Bouncer.Ticket> bouncerQueue = new ArrayDeque<Bouncer.Ticket>();

        private RunAllFullyRunnable(Yielder<? extends FrameProcessor<T>> processorYielder) {
            this.processorYielder = processorYielder;
            this.finishedFuture = RunAllFullyWidget.this.exec.registerCancelableFuture(SettableFuture.create(), false, RunAllFullyWidget.this.cancellationId);
            this.finishedFuture.addListener(() -> {
                if (this.finishedFuture.isCancelled()) {
                    try {
                        Object object = this.runAllFullyLock;
                        synchronized (object) {
                            ImmutableList.copyOf(this.outstandingFutures).forEach(f -> f.cancel(true));
                            this.cleanupIfNoMoreProcessors();
                        }
                    }
                    catch (Throwable e) {
                        log.warn(e, "Exception encountered while cleaning up canceled runAllFully execution", new Object[0]);
                    }
                }
            }, (Executor)Execs.directExecutor());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Bouncer.Ticket nextTicket = null;
            Object object = this.runAllFullyLock;
            synchronized (object) {
                FrameProcessor nextProcessor;
                if (this.finished.get() != null) {
                    this.cleanupIfNoMoreProcessors();
                    return;
                }
                if (!this.processorYielder.isDone()) {
                    assert (this.bouncerQueue != null);
                    try {
                        Bouncer.Ticket ticketFromQueue = this.bouncerQueue.poll();
                        if (ticketFromQueue != null) {
                            nextTicket = ticketFromQueue;
                        } else {
                            ListenableFuture<Bouncer.Ticket> ticketFuture = RunAllFullyWidget.this.exec.registerCancelableFuture(RunAllFullyWidget.this.bouncer.ticket(), false, RunAllFullyWidget.this.cancellationId);
                            if (ticketFuture.isDone() && !ticketFuture.isCancelled()) {
                                nextTicket = (Bouncer.Ticket)FutureUtils.getUncheckedImmediately(ticketFuture);
                            } else {
                                ticketFuture.addListener(() -> {
                                    if (!ticketFuture.isCancelled()) {
                                        Bouncer.Ticket ticket = (Bouncer.Ticket)FutureUtils.getUncheckedImmediately((ListenableFuture)ticketFuture);
                                        Object object = this.runAllFullyLock;
                                        synchronized (object) {
                                            if (this.finished.get() != null) {
                                                ticket.giveBack();
                                                return;
                                            }
                                            this.bouncerQueue.add(ticket);
                                        }
                                        RunAllFullyWidget.this.exec.getExecutorService().submit((Runnable)this);
                                    }
                                }, (Executor)Execs.directExecutor());
                                return;
                            }
                        }
                        assert (this.outstandingProcessors < RunAllFullyWidget.this.maxOutstandingProcessors);
                        nextProcessor = (FrameProcessor)this.processorYielder.get();
                        this.processorYielder = this.processorYielder.next(null);
                        ++this.outstandingProcessors;
                    }
                    catch (Throwable e) {
                        if (nextTicket != null) {
                            nextTicket.giveBack();
                        }
                        this.finished.compareAndSet(null, Either.error((Object)e));
                        this.cleanupIfNoMoreProcessors();
                        return;
                    }
                } else {
                    return;
                }
                assert (nextTicket != null);
                final ListenableFuture future = RunAllFullyWidget.this.exec.runFully(FrameProcessors.withBaggage(nextProcessor, nextTicket::giveBack), RunAllFullyWidget.this.cancellationId);
                this.outstandingFutures.add(future);
                Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess(T result) {
                        boolean isDone;
                        Object object;
                        Object retVal = null;
                        try {
                            object = RunAllFullyRunnable.this.runAllFullyLock;
                            synchronized (object) {
                                --RunAllFullyRunnable.this.outstandingProcessors;
                                RunAllFullyRunnable.this.outstandingFutures.remove(future);
                                if (!RunAllFullyRunnable.this.seenFirstResult) {
                                    RunAllFullyRunnable.this.currentResult = RunAllFullyWidget.this.accumulateFn.apply(RunAllFullyWidget.this.initialResult, result);
                                    RunAllFullyRunnable.this.seenFirstResult = true;
                                } else {
                                    RunAllFullyRunnable.this.currentResult = RunAllFullyWidget.this.accumulateFn.apply(RunAllFullyRunnable.this.currentResult, result);
                                }
                                boolean bl = isDone = RunAllFullyRunnable.this.outstandingProcessors == 0 && RunAllFullyRunnable.this.processorYielder.isDone();
                                if (isDone) {
                                    retVal = RunAllFullyRunnable.this.currentResult;
                                }
                            }
                        }
                        catch (Throwable e) {
                            RunAllFullyRunnable.this.finished.compareAndSet(null, Either.error((Object)e));
                            Object object2 = RunAllFullyRunnable.this.runAllFullyLock;
                            synchronized (object2) {
                                RunAllFullyRunnable.this.cleanupIfNoMoreProcessors();
                            }
                            return;
                        }
                        if (isDone) {
                            RunAllFullyRunnable.this.finished.compareAndSet(null, Either.value(retVal));
                            object = RunAllFullyRunnable.this.runAllFullyLock;
                            synchronized (object) {
                                RunAllFullyRunnable.this.cleanupIfNoMoreProcessors();
                            }
                        } else {
                            RunAllFullyWidget.this.exec.getExecutorService().submit((Runnable)RunAllFullyRunnable.this);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onFailure(Throwable t) {
                        RunAllFullyRunnable.this.finished.compareAndSet(null, Either.error((Object)t));
                        Object object = RunAllFullyRunnable.this.runAllFullyLock;
                        synchronized (object) {
                            --RunAllFullyRunnable.this.outstandingProcessors;
                            RunAllFullyRunnable.this.outstandingFutures.remove(future);
                            RunAllFullyRunnable.this.cleanupIfNoMoreProcessors();
                        }
                    }
                });
            }
        }

        @GuardedBy(value="runAllFullyLock")
        private void cleanupIfNoMoreProcessors() {
            if (this.outstandingProcessors == 0 && this.finished.get() != null) {
                this.cleanup();
            }
        }

        @GuardedBy(value="runAllFullyLock")
        private void cleanup() {
            assert (this.finished.get() != null);
            assert (this.outstandingProcessors == 0);
            try {
                if (this.bouncerQueue != null) {
                    Bouncer.Ticket ticket;
                    while ((ticket = this.bouncerQueue.poll()) != null) {
                        ticket.giveBack();
                    }
                    this.bouncerQueue = null;
                }
                if (this.processorYielder != null) {
                    this.processorYielder.close();
                    this.processorYielder = null;
                }
            }
            catch (Throwable e) {
                log.noStackTrace().warn(e, "Exception encountered while cleaning up from runAllFully", new Object[0]);
            }
            finally {
                if (this.finished.get().isValue()) {
                    this.finishedFuture.set(this.finished.get().valueOrThrow());
                } else {
                    this.finishedFuture.setException((Throwable)this.finished.get().error());
                }
            }
        }
    }
}

