/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.channel.ReadableFileFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameFileChannel;
import org.apache.druid.frame.file.FrameFile;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;

public class FileOutputChannelFactory
implements OutputChannelFactory {
    private final File fileChannelsDirectory;
    private final int frameSize;

    public FileOutputChannelFactory(File fileChannelsDirectory, int frameSize) {
        this.fileChannelsDirectory = fileChannelsDirectory;
        this.frameSize = frameSize;
    }

    @Override
    public OutputChannel openChannel(int partitionNumber) throws IOException {
        FileUtils.mkdirp((File)this.fileChannelsDirectory);
        String fileName = StringUtils.format((String)"part_%06d_%s", (Object[])new Object[]{partitionNumber, UUID.randomUUID().toString()});
        File file = new File(this.fileChannelsDirectory, fileName);
        WritableFrameFileChannel writableChannel = new WritableFrameFileChannel(FrameFileWriter.open(Files.newByteChannel(file.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), ByteBuffer.allocate(Frame.compressionBufferSize(this.frameSize))));
        java.util.function.Supplier<ReadableFrameChannel> readableChannelSupplier = () -> ((Supplier)Suppliers.memoize(() -> {
            try {
                FrameFile frameFile = FrameFile.open(file, FrameFile.Flag.DELETE_ON_CLOSE);
                return new ReadableFileFrameChannel(frameFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).get();
        return OutputChannel.pair(writableChannel, ArenaMemoryAllocator.createOnHeap(this.frameSize), readableChannelSupplier, partitionNumber);
    }

    @Override
    public OutputChannel openNilChannel(int partitionNumber) {
        return OutputChannel.nil(partitionNumber);
    }
}

