/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class LongFieldWriter
implements FieldWriter {
    public static final int SIZE = 9;
    public static final byte NULL_BYTE = 0;
    public static final byte NOT_NULL_BYTE = 1;
    private final BaseLongColumnValueSelector selector;

    public LongFieldWriter(BaseLongColumnValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public long writeTo(WritableMemory memory, long position, long maxSize) {
        if (maxSize < 9L) {
            return -1L;
        }
        if (this.selector.isNull()) {
            memory.putByte(position, (byte)0);
            memory.putLong(position + 1L, 0L);
        } else {
            memory.putByte(position, (byte)1);
            memory.putLong(position + 1L, Long.reverseBytes(this.selector.getLong() ^ Long.MIN_VALUE));
        }
        return 9L;
    }

    @Override
    public void close() {
    }
}

