/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.allocation;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;

public class AppendableMemory
implements Closeable {
    private static final int NO_BLOCK = -1;
    private static final int DEFAULT_INITIAL_ALLOCATION_SIZE = 360;
    private static final int SOFT_MAXIMUM_ALLOCATION_SIZE = 1474560;
    private final MemoryAllocator allocator;
    private int nextAllocationSize;
    private final List<ResourceHolder<WritableMemory>> blockHolders = new ArrayList<ResourceHolder<WritableMemory>>();
    private final IntList limits = new IntArrayList();
    private final LongArrayList globalStartPositions = new LongArrayList();
    private boolean blocksPackedAndInitialSize = true;
    private final MemoryRange<WritableMemory> cursor;

    private AppendableMemory(MemoryAllocator allocator, int initialAllocationSize) {
        this.allocator = allocator;
        this.nextAllocationSize = initialAllocationSize;
        this.cursor = new MemoryRange<Object>(null, 0L, 0L);
    }

    public static AppendableMemory create(MemoryAllocator allocator) {
        return new AppendableMemory(allocator, 360);
    }

    public static AppendableMemory create(MemoryAllocator allocator, int initialAllocationSize) {
        return new AppendableMemory(allocator, initialAllocationSize);
    }

    public MemoryRange<WritableMemory> cursor() {
        return this.cursor;
    }

    public boolean reserveAdditional(int bytes) {
        if (bytes < 0) {
            throw new IAE("Cannot reserve negative bytes", new Object[0]);
        }
        if (bytes == 0) {
            return true;
        }
        if ((long)bytes > this.allocator.available()) {
            return false;
        }
        int idx = this.blockHolders.size() - 1;
        if (idx < 0 || (long)(bytes + this.limits.getInt(idx)) > ((WritableMemory)this.blockHolders.get(idx).get()).getCapacity()) {
            Optional<ResourceHolder<WritableMemory>> newMemory = this.allocator.allocate(Math.max(this.nextAllocationSize, bytes));
            if (!newMemory.isPresent()) {
                return false;
            }
            if (((WritableMemory)newMemory.get().get()).getCapacity() < (long)bytes) {
                newMemory.get().close();
                return false;
            }
            this.addBlock(newMemory.get());
            if (!this.blocksPackedAndInitialSize && this.nextAllocationSize < 1474560) {
                this.nextAllocationSize *= 2;
            }
        }
        return true;
    }

    public void advanceCursor(int bytes) {
        int blockNumber = this.currentBlockNumber();
        if (blockNumber < 0) {
            throw new ISE("No memory; must call 'reserve' first", new Object[0]);
        }
        int currentLimit = this.limits.getInt(blockNumber);
        WritableMemory currentBlockMemory = (WritableMemory)this.blockHolders.get(blockNumber).get();
        long available = currentBlockMemory.getCapacity() - (long)currentLimit;
        if ((long)bytes > available) {
            throw new IAE("Cannot advance [%d] bytes; current block only has [%d] additional bytes", new Object[]{bytes, available});
        }
        int newLimit = currentLimit + bytes;
        this.limits.set(blockNumber, newLimit);
        this.cursor.set(currentBlockMemory, newLimit, currentBlockMemory.getCapacity() - (long)newLimit);
    }

    public void rewindCursor(int bytes) {
        if (bytes < 0) {
            throw new IAE("bytes < 0", new Object[0]);
        }
        if (bytes == 0) {
            return;
        }
        int blockNumber = this.currentBlockNumber();
        if (blockNumber < 0) {
            throw new ISE("No memory; must call 'reserve' first", new Object[0]);
        }
        int currentLimit = this.limits.getInt(blockNumber);
        if (bytes > currentLimit) {
            throw new IAE("Cannot rewind [%d] bytes; current block is only [%d] bytes long", new Object[]{bytes, currentLimit});
        }
        int newLimit = currentLimit - bytes;
        this.limits.set(blockNumber, newLimit);
        WritableMemory currentBlockMemory = (WritableMemory)this.blockHolders.get(blockNumber).get();
        this.cursor.set(currentBlockMemory, newLimit, currentBlockMemory.getCapacity() - (long)newLimit);
    }

    public long size() {
        long sz = 0L;
        for (int i = 0; i < this.limits.size(); ++i) {
            sz += (long)this.limits.getInt(i);
        }
        return sz;
    }

    public long writeTo(WritableMemory memory, long startPosition) {
        long currentPosition = startPosition;
        for (int i = 0; i < this.blockHolders.size(); ++i) {
            ResourceHolder<WritableMemory> memoryHolder = this.blockHolders.get(i);
            WritableMemory srcMemory = (WritableMemory)memoryHolder.get();
            int limit = this.limits.getInt(i);
            srcMemory.copyTo(0L, memory, currentPosition, (long)limit);
            currentPosition += (long)limit;
        }
        return currentPosition - startPosition;
    }

    public void clear() {
        this.blockHolders.forEach(ResourceHolder::close);
        this.blockHolders.clear();
        this.limits.clear();
        this.globalStartPositions.clear();
        this.cursor.set(null, 0L, 0L);
    }

    @Override
    public void close() {
        this.clear();
    }

    private void addBlock(ResourceHolder<WritableMemory> block) {
        int lastBlockNumber = this.currentBlockNumber();
        WritableMemory blockMemory = (WritableMemory)block.get();
        if (lastBlockNumber == -1) {
            this.globalStartPositions.add(0L);
        } else {
            int lastBlockLimit = this.limits.getInt(lastBlockNumber);
            long newBlockGlobalStartPosition = this.globalStartPositions.getLong(lastBlockNumber) + (long)lastBlockLimit;
            this.globalStartPositions.add(newBlockGlobalStartPosition);
            if (blockMemory.getCapacity() != 360L || lastBlockLimit != 360) {
                this.blocksPackedAndInitialSize = false;
            }
        }
        this.blockHolders.add(block);
        this.limits.add(0);
        this.cursor.set(blockMemory, 0L, blockMemory.getCapacity());
    }

    private int currentBlockNumber() {
        if (this.blockHolders.isEmpty()) {
            return -1;
        }
        return this.blockHolders.size() - 1;
    }
}

