/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.ber;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.States;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.TLVStateEnum;

public abstract class AbstractContainer
implements Asn1Container {
    private Grammar<? extends Asn1Container> grammar;
    private TLVStateEnum state;
    private Enum<?> transition;
    private TLV tlv;
    private TLV parentTLV;
    private boolean grammarEndAllowed;
    private int decodedBytes;
    private int maxPDUSize = Integer.MAX_VALUE;
    private int id = 0;
    private ByteBuffer stream;
    private boolean gathering = false;

    protected AbstractContainer() {
        this.state = TLVStateEnum.TAG_STATE_START;
    }

    protected AbstractContainer(ByteBuffer stream) {
        this.state = TLVStateEnum.TAG_STATE_START;
        this.stream = stream;
    }

    @Override
    public Grammar<? extends Asn1Container> getGrammar() {
        return this.grammar;
    }

    @Override
    public void setGrammar(Grammar<? extends Asn1Container> grammar) {
        this.grammar = grammar;
    }

    @Override
    public TLVStateEnum getState() {
        return this.state;
    }

    @Override
    public void setState(TLVStateEnum state) {
        this.state = state;
    }

    @Override
    public boolean isGrammarEndAllowed() {
        return this.grammarEndAllowed;
    }

    @Override
    public void setGrammarEndAllowed(boolean grammarEndAllowed) {
        this.grammarEndAllowed = grammarEndAllowed;
    }

    @Override
    public Enum<?> getTransition() {
        return this.transition;
    }

    @Override
    public void setTransition(Enum<?> transition) {
        this.transition = transition;
    }

    @Override
    public void setCurrentTLV(TLV currentTLV) {
        this.tlv = currentTLV;
    }

    @Override
    public TLV getCurrentTLV() {
        return this.tlv;
    }

    @Override
    public TLV getParentTLV() {
        return this.parentTLV;
    }

    @Override
    public void setParentTLV(TLV parentTLV) {
        this.parentTLV = parentTLV;
    }

    public void clean() {
        this.tlv = null;
        this.parentTLV = null;
        this.transition = ((States)((Object)this.transition)).getStartState();
        this.state = TLVStateEnum.TAG_STATE_START;
    }

    @Override
    public int getNewTlvId() {
        return this.id++;
    }

    @Override
    public int getTlvId() {
        return this.tlv.getId();
    }

    @Override
    public int getDecodedBytes() {
        return this.decodedBytes;
    }

    @Override
    public void setDecodedBytes(int decodedBytes) {
        this.decodedBytes = decodedBytes;
    }

    @Override
    public void incrementDecodedBytes(int nb) {
        this.decodedBytes += nb;
    }

    @Override
    public int getMaxPDUSize() {
        return this.maxPDUSize;
    }

    @Override
    public void setMaxPDUSize(int maxPDUSize) {
        this.maxPDUSize = maxPDUSize > 0 ? maxPDUSize : Integer.MAX_VALUE;
    }

    @Override
    public ByteBuffer getStream() {
        return this.stream;
    }

    @Override
    public void setStream(ByteBuffer stream) {
        this.stream = stream;
    }

    @Override
    public void rewind() {
        int start = this.stream.position() - 1 - this.tlv.getLengthNbBytes();
        this.stream.position(start);
    }

    @Override
    public void updateParent() {
        TLV parentTlv;
        for (parentTlv = this.tlv.getParent(); parentTlv != null && parentTlv.getExpectedLength() == 0; parentTlv = parentTlv.getParent()) {
        }
        this.parentTLV = parentTlv;
    }

    @Override
    public boolean isGathering() {
        return this.gathering;
    }

    @Override
    public void setGathering(boolean gathering) {
        this.gathering = gathering;
    }
}

