/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.webp.chunks;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunk;
import org.apache.commons.imaging.internal.SafeOperations;

public final class WebPChunkVp8l
extends WebPChunk {
    private final int imageWidth;
    private final int imageHeight;
    private final boolean hasAlpha;
    private final int versionNumber;

    public WebPChunkVp8l(int type, int size, byte[] bytes) throws ImagingException {
        super(type, size, bytes);
        if (bytes[0] != 47 || size < 5) {
            throw new ImagingException("Invalid VP8L chunk");
        }
        int b1 = bytes[1] & 0xFF;
        int b2 = bytes[2] & 0xFF;
        int b3 = bytes[3] & 0xFF;
        int b4 = bytes[4] & 0xFF;
        this.imageWidth = b1 + ((b2 & 0x3F) << 8) + 1;
        this.imageHeight = SafeOperations.add((b2 & 0xC0) >> 6, b3 << 2, (b4 & 0xF) << 8, 1);
        this.hasAlpha = (b4 & 0x10) != 0;
        this.versionNumber = b4 >> 5;
        if (this.versionNumber != 0) {
            throw new ImagingException("VP8L version should be 0");
        }
    }

    @Override
    public void dump(PrintWriter pw, int offset) throws ImagingException, IOException {
        super.dump(pw, offset);
        pw.println("  Version Number: " + this.getVersionNumber());
        pw.println("  Image Width: " + this.getImageWidth());
        pw.println("  Image Height: " + this.getImageHeight());
        pw.println("  Alpha: " + this.hasAlpha());
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }
}

