/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SalesforceEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":operationName:topicName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "salesforce".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "operationName", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "topicName", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(69);
        props.add("allOrNone");
        props.add("apexMethod");
        props.add("apexQueryParams");
        props.add("apexUrl");
        props.add("apiVersion");
        props.add("backoffIncrement");
        props.add("batchId");
        props.add("bridgeErrorHandler");
        props.add("compositeMethod");
        props.add("contentType");
        props.add("defaultReplayId");
        props.add("eventName");
        props.add("eventSchemaFormat");
        props.add("eventSchemaId");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("fallBackReplayId");
        props.add("fallbackToLatestReplayId");
        props.add("format");
        props.add("httpClient");
        props.add("includeDetails");
        props.add("initialReplayIdMap");
        props.add("instanceId");
        props.add("jobId");
        props.add("lazyStartProducer");
        props.add("limit");
        props.add("locator");
        props.add("maxBackoff");
        props.add("maxRecords");
        props.add("notFoundBehaviour");
        props.add("notifyForFields");
        props.add("notifyForOperationCreate");
        props.add("notifyForOperationDelete");
        props.add("notifyForOperationUndelete");
        props.add("notifyForOperationUpdate");
        props.add("notifyForOperations");
        props.add("objectMapper");
        props.add("operationName");
        props.add("pkChunking");
        props.add("pkChunkingChunkSize");
        props.add("pkChunkingParent");
        props.add("pkChunkingStartRow");
        props.add("pubSubBatchSize");
        props.add("pubSubDeserializeType");
        props.add("pubSubPojoClass");
        props.add("pubSubReplayId");
        props.add("queryLocator");
        props.add("rawHttpHeaders");
        props.add("rawMethod");
        props.add("rawPath");
        props.add("rawPayload");
        props.add("rawQueryParameters");
        props.add("replayId");
        props.add("replayPreset");
        props.add("reportId");
        props.add("reportMetadata");
        props.add("resultId");
        props.add("sObjectBlobFieldName");
        props.add("sObjectClass");
        props.add("sObjectFields");
        props.add("sObjectId");
        props.add("sObjectIdName");
        props.add("sObjectIdValue");
        props.add("sObjectName");
        props.add("sObjectQuery");
        props.add("sObjectSearch");
        props.add("streamQueryResult");
        props.add("topicName");
        props.add("updateTopic");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptyMap();
    }
}

