/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.api.kv;

import org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.bookkeeper.api.kv.op.CompareResult;
import org.apache.bookkeeper.api.kv.op.DeleteOp;
import org.apache.bookkeeper.api.kv.op.IncrementOp;
import org.apache.bookkeeper.api.kv.op.OpFactory;
import org.apache.bookkeeper.api.kv.op.PutOp;
import org.apache.bookkeeper.api.kv.op.RangeOp;
import org.apache.bookkeeper.api.kv.options.Options;

public interface PTableBase<K, V>
extends AutoCloseable {
    public OpFactory<K, V> opFactory();

    default public CompareOp<K, V> compareCreateRevision(CompareResult result, K key, long revision) {
        return this.opFactory().compareCreateRevision(result, key, revision);
    }

    default public CompareOp<K, V> compareModRevision(CompareResult result, K key, long revision) {
        return this.opFactory().compareModRevision(result, key, revision);
    }

    default public CompareOp<K, V> compareVersion(CompareResult result, K key, long version) {
        return this.opFactory().compareVersion(result, key, version);
    }

    default public CompareOp<K, V> compareValue(CompareResult result, K key, V value) {
        return this.opFactory().compareValue(result, key, value);
    }

    default public PutOp<K, V> newPut(K key, V value) {
        return this.opFactory().newPut(key, value, Options.blindPut());
    }

    default public DeleteOp<K, V> newDelete(K key) {
        return this.opFactory().newDelete(key, Options.delete());
    }

    default public IncrementOp<K, V> newIncrement(K key, long amount) {
        return this.opFactory().newIncrement(key, amount, Options.blindIncrement());
    }

    default public IncrementOp<K, V> newIncrementAndGet(K key, long amount) {
        return this.opFactory().newIncrement(key, amount, Options.incrementAndGet());
    }

    default public RangeOp<K, V> newGet(K key) {
        return this.opFactory().newRange(key, Options.get());
    }

    @Override
    public void close();
}

