/*
 * Decompiled with CFR 0.152.
 */
package weka.core.expressionlanguage.weka;

import java.util.regex.Pattern;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.core.Macro;
import weka.core.expressionlanguage.core.MacroDeclarations;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.core.SemanticException;
import weka.core.expressionlanguage.core.VariableDeclarations;

public class InstancesHelper
implements VariableDeclarations,
Macro,
MacroDeclarations {
    private static final Pattern ATTRIBUTE1 = Pattern.compile("[aA][0-9]+");
    private static final Pattern ATTRIBUTE2 = Pattern.compile("ATT[0-9]+");
    private static final String CLASS = "CLASS";
    private static final String IS_MISSING = "ismissing";
    private static final long serialVersionUID = -4398876812339967703L;
    private final Instances dataset;
    private Instance instance;
    private boolean missingAccessed = false;
    private final boolean dataRetained;

    public InstancesHelper(Instances dataset) {
        this(dataset, false);
    }

    public InstancesHelper(Instances dataset, boolean retainData) {
        assert (dataset != null);
        this.dataset = retainData ? dataset : new Instances(dataset, 0);
        this.dataRetained = retainData;
    }

    @Override
    public boolean hasMacro(String name) {
        return IS_MISSING.equals(name);
    }

    @Override
    public Macro getMacro(String name) {
        if (this.hasMacro(name)) {
            return this;
        }
        throw new RuntimeException("Macro '" + name + "' undefined!");
    }

    @Override
    public Node evaluate(Node ... params) throws SemanticException {
        if (params.length != 1) {
            throw new SemanticException("Macro ismissing takes exactly one argument!");
        }
        if (params[0] instanceof Value) {
            return new isMissing((Value)params[0]);
        }
        throw new SemanticException("ismissing is only applicable to a dataset value!");
    }

    public void setInstance(int i) {
        if (!this.dataRetained) {
            throw new UnsupportedOperationException("Unable to set the instance based on index because the dataset has not been retained in memory");
        }
        this.setInstance(this.dataset.get(i));
    }

    public void setInstance(Instance instance) {
        assert (this.dataset.equalHeaders(instance.dataset()));
        this.instance = instance;
        this.missingAccessed = false;
    }

    public boolean missingAccessed() {
        return this.missingAccessed;
    }

    private int getIndex(String attribute) {
        if (ATTRIBUTE1.matcher(attribute).matches()) {
            return Integer.parseInt(attribute.substring(1)) - 1;
        }
        if (ATTRIBUTE2.matcher(attribute).matches()) {
            return Integer.parseInt(attribute.substring(3)) - 1;
        }
        if (CLASS.equals(attribute)) {
            return this.dataset.classIndex();
        }
        return -1;
    }

    @Override
    public boolean hasVariable(String name) {
        int index = this.getIndex(name);
        return 0 <= index && index < this.dataset.numAttributes();
    }

    @Override
    public Node getVariable(String name) {
        int index = this.getIndex(name);
        if (index < 0 || index >= this.dataset.numAttributes()) {
            throw new RuntimeException("Variable '" + name + "' undefined!");
        }
        if (this.dataset.attribute(index).isNumeric()) {
            return new DoubleValue(index);
        }
        if (this.dataset.attribute(index).isString() || this.dataset.attribute(index).isNominal()) {
            return new StringValue(index);
        }
        throw new RuntimeException("Attributes of type '" + this.dataset.attribute(index).toString() + "' not supported!");
    }

    private abstract class Value
    implements Node {
        private static final long serialVersionUID = 5839070716097467627L;
        private final int index;

        public Value(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isMissing() {
            return InstancesHelper.this.instance.isMissing(this.getIndex());
        }
    }

    private static class isMissing
    implements Primitives.BooleanExpression {
        private static final long serialVersionUID = -3805035561340865906L;
        private final Value value;

        public isMissing(Value value) {
            this.value = value;
        }

        @Override
        public boolean evaluate() {
            return this.value.isMissing();
        }
    }

    private class DoubleValue
    extends Value
    implements Primitives.DoubleExpression {
        private static final long serialVersionUID = -1001674545929082424L;

        public DoubleValue(int index) {
            super(index);
            assert (InstancesHelper.this.dataset.attribute(this.getIndex()).isNumeric());
        }

        @Override
        public double evaluate() {
            if (this.isMissing()) {
                InstancesHelper.this.missingAccessed = true;
                return Utils.missingValue();
            }
            return InstancesHelper.this.instance.value(this.getIndex());
        }
    }

    private class StringValue
    extends Value
    implements Primitives.StringExpression {
        private static final long serialVersionUID = -249974216283801876L;

        public StringValue(int index) {
            super(index);
            assert (InstancesHelper.this.dataset.attribute(index).isString() || InstancesHelper.this.dataset.attribute(index).isNominal());
        }

        @Override
        public String evaluate() {
            if (this.isMissing()) {
                InstancesHelper.this.missingAccessed = true;
                return "";
            }
            return InstancesHelper.this.instance.stringValue(this.getIndex());
        }
    }
}

