/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import weka.core.PluginManager;
import weka.core.WekaException;
import weka.gui.knowledgeflow.AbstractGraphicalCommand;
import weka.gui.knowledgeflow.GraphicalEnvironmentCommandHandler;
import weka.gui.knowledgeflow.MainKFPerspective;

public class KFGraphicalEnvironmentCommandHandler
implements GraphicalEnvironmentCommandHandler {
    protected MainKFPerspective m_mainPerspective;
    protected Map<String, AbstractGraphicalCommand> m_commands = new HashMap<String, AbstractGraphicalCommand>();

    public KFGraphicalEnvironmentCommandHandler(MainKFPerspective mainPerspective) {
        this.m_mainPerspective = mainPerspective;
        Set<String> commands = PluginManager.getPluginNamesOfType("weka.gui.knowledgeflow.AbstractGraphicalCommand");
        try {
            for (String commandClass : commands) {
                AbstractGraphicalCommand impl = (AbstractGraphicalCommand)PluginManager.getPluginInstance("weka.gui.knowledgeflow.AbstractGraphicalCommand", commandClass);
                this.m_commands.put(impl.getCommandName(), impl);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public <T> T performCommand(String commandName, Object ... commandArgs) throws WekaException {
        AbstractGraphicalCommand command = this.m_commands.get(commandName);
        if (command != null) {
            command.setGraphicalEnvironment(this.m_mainPerspective);
            return command.performCommand(commandArgs);
        }
        throw new WekaException("Unknown graphical command '" + commandName + "'");
    }

    static {
        PluginManager.addPlugin("weka.gui.knowledgeflow.AbstractGraphicalCommand", "weka.gui.knowledgeflow.GetPerspectiveNamesGraphicalCommand", "weka.gui.knowledgeflow.GetPerspectiveNamesGraphicalCommand", true);
        PluginManager.addPlugin("weka.gui.knowledgeflow.AbstractGraphicalCommand", "weka.gui.knowledgeflow.SendToPerspectiveGraphicalCommand", "weka.gui.knowledgeflow.SendToPerspectiveGraphicalCommand", true);
    }
}

