/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class InstanceComparator
implements Comparator<Instance>,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -6589278678230949683L;
    protected boolean m_IncludeClass;
    protected Range m_Range = new Range();

    public InstanceComparator() {
        this(true);
    }

    public InstanceComparator(boolean includeClass) {
        this(includeClass, "first-last", false);
    }

    public InstanceComparator(boolean includeClass, String range, boolean invert) {
        this.setIncludeClass(includeClass);
        this.setRange(range);
        this.setInvert(invert);
    }

    public void setIncludeClass(boolean includeClass) {
        this.m_IncludeClass = includeClass;
    }

    public boolean getIncludeClass() {
        return this.m_IncludeClass;
    }

    public void setRange(String value) {
        this.m_Range.setRanges(value);
    }

    public String getRange() {
        return this.m_Range.getRanges();
    }

    public void setInvert(boolean invert) {
        this.m_Range.setInvert(invert);
    }

    public boolean getInvert() {
        return this.m_Range.getInvert();
    }

    @Override
    public int compare(Instance inst1, Instance inst2) {
        this.m_Range.setUpper(inst1.numAttributes() - 1);
        int classindex = inst1.classIndex() == -1 ? inst1.numAttributes() - 1 : inst1.classIndex();
        int result = 0;
        block4: for (int i = 0; i < inst1.numAttributes(); ++i) {
            if (!this.m_Range.isInRange(i) || !this.getIncludeClass() && i == classindex) continue;
            if (inst1.isMissing(i) || inst2.isMissing(i)) {
                if (inst1.isMissing(i) && inst2.isMissing(i)) continue;
                if (inst1.isMissing(i)) {
                    result = -1;
                    break;
                }
                result = 1;
                break;
            }
            switch (inst1.attribute(i).type()) {
                case 2: {
                    result = inst1.stringValue(i).compareTo(inst2.stringValue(i));
                    break;
                }
                case 4: {
                    Instances data1 = inst1.relationalValue(i);
                    Instances data2 = inst2.relationalValue(i);
                    InstanceComparator comp = new InstanceComparator();
                    for (int n = 0; n < data1.numInstances() && n < data2.numInstances() && result == 0; ++n) {
                        result = comp.compare(data1.instance(n), data2.instance(n));
                    }
                    break;
                }
                default: {
                    if (inst1.value(i) == inst2.value(i)) continue block4;
                    result = inst1.value(i) < inst2.value(i) ? -1 : 1;
                }
            }
            if (result != 0) break;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14912 $");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            return;
        }
        Instances inst = new Instances(new BufferedReader(new FileReader(args[0])));
        inst.setClassIndex(inst.numAttributes() - 1);
        InstanceComparator comp = new InstanceComparator();
        System.out.println("\nIncluding the class");
        System.out.println("comparing 1. instance with 1.: " + comp.compare(inst.instance(0), inst.instance(0)));
        System.out.println("comparing 1. instance with 2.: " + comp.compare(inst.instance(0), inst.instance(1)));
        System.out.println("comparing 2. instance with 1.: " + comp.compare(inst.instance(1), inst.instance(0)));
        comp = new InstanceComparator(false);
        System.out.println("\nExcluding the class");
        System.out.println("comparing 1. instance with 1.: " + comp.compare(inst.instance(0), inst.instance(0)));
        System.out.println("comparing 1. instance with 2.: " + comp.compare(inst.instance(0), inst.instance(1)));
        System.out.println("comparing 2. instance with 1.: " + comp.compare(inst.instance(1), inst.instance(0)));
        Instances tmp = new Instances(inst);
        Collections.sort(tmp, new InstanceComparator(false));
        System.out.println("\nSorted on all attributes");
        System.out.println(tmp);
        tmp = new Instances(inst);
        Collections.sort(tmp, new InstanceComparator(false, "2", false));
        System.out.println("\nSorted on 2nd attribute");
        System.out.println(tmp);
    }
}

