/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.gitignore;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitIgnore {
    private static final String GITIGNORE_PATH_SEPARATOR = "/";
    private static final Logger LOG = LoggerFactory.getLogger(GitIgnore.class);
    private final String projectRelativeBaseDir;
    private final List<IgnoreRule> ignoreRules = new ArrayList<IgnoreRule>();
    private boolean verbose = false;

    public GitIgnore(File file) throws IOException {
        this("", file);
    }

    public GitIgnore(String projectRelativeBaseDir, File file) throws IOException {
        this(projectRelativeBaseDir, FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
    }

    public GitIgnore(String gitIgnoreContent) {
        this("", gitIgnoreContent);
    }

    public GitIgnore(String gitIgnoreContent, boolean verbose) {
        this("", gitIgnoreContent, verbose);
    }

    public GitIgnore(String projectRelativeBaseDir, String gitIgnoreContent) {
        this(projectRelativeBaseDir, gitIgnoreContent, false);
    }

    public GitIgnore(String projectRelativeBaseDir, String gitIgnoreContent, boolean verbose) {
        this.verbose = verbose;
        this.projectRelativeBaseDir = GitIgnore.standardizeFilename(projectRelativeBaseDir + GITIGNORE_PATH_SEPARATOR);
        if (gitIgnoreContent == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new StringReader(gitIgnoreContent));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("!")) {
                    this.ignoreRules.add(new IgnoreRule(this.projectRelativeBaseDir, true, line.substring(1), verbose));
                    continue;
                }
                this.ignoreRules.add(new IgnoreRule(this.projectRelativeBaseDir, false, line, verbose));
            }
        }
        catch (IOException io) {
            LOG.error("Got an IOException while reading the gitignore file content: {}", (Throwable)io);
        }
    }

    public Boolean isIgnoredFile(String filename) {
        Boolean mustBeIgnored;
        block9: {
            String matchFileName;
            block8: {
                if (this.verbose) {
                    LOG.info("# vvvvvvvvvvvvvvvvvvvvvvvvvvv");
                    LOG.info("Checking: {}", (Object)filename);
                }
                matchFileName = GitIgnore.standardizeFilename(filename);
                if (this.verbose) {
                    LOG.info("Matching: {}", (Object)matchFileName);
                }
                mustBeIgnored = null;
                if (matchFileName.startsWith(this.projectRelativeBaseDir)) break block8;
                if (!this.verbose) break block9;
                LOG.info("# Not in my baseDir: {}", (Object)this.projectRelativeBaseDir);
                break block9;
            }
            for (IgnoreRule ignoreRule : this.ignoreRules) {
                Boolean ruleVerdict = ignoreRule.isIgnoredFile(matchFileName);
                if (ruleVerdict == null) continue;
                mustBeIgnored = ruleVerdict;
                if (!ruleVerdict.booleanValue() || !ignoreRule.isDirectoryMatch()) continue;
                break;
            }
        }
        if (this.verbose) {
            if (mustBeIgnored == null) {
                LOG.info("Conclusion: Not matched: Not ignored");
            } else if (Boolean.TRUE.equals(mustBeIgnored)) {
                LOG.info("Conclusion: Must be ignored");
            } else {
                LOG.info("Conclusion: Must NOT be ignored");
            }
        }
        return mustBeIgnored;
    }

    static String standardizeFilename(String filename) {
        String unixifiedName = FilenameUtils.separatorsToUnix((String)filename);
        if (!unixifiedName.matches("^[a-zA-Z]:/.*")) {
            unixifiedName = GITIGNORE_PATH_SEPARATOR + unixifiedName;
        }
        return unixifiedName.replaceAll("/+", GITIGNORE_PATH_SEPARATOR);
    }

    public boolean ignoreFile(String filename) {
        return Boolean.TRUE.equals(this.isIgnoredFile(filename));
    }

    public boolean keepFile(String filename) {
        return !this.ignoreFile(filename);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.ignoreRules.forEach(rule -> rule.setVerbose(verbose));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("# GitIgnore file:\n");
        for (IgnoreRule ignoreRule : this.ignoreRules) {
            result.append(ignoreRule).append('\n');
        }
        return result.toString();
    }

    public String getProjectRelativeBaseDir() {
        return this.projectRelativeBaseDir;
    }

    List<IgnoreRule> getIgnoreRules() {
        return new ArrayList<IgnoreRule>(this.ignoreRules);
    }

    static class IgnoreRule {
        private final String projectRelativeBaseDir;
        private final boolean negate;
        private final String fileExpression;
        private final boolean directoryMatch;
        private final Pattern filePattern;
        private boolean verbose;

        public IgnoreRule(String projectRelativeBaseDir, boolean negate, String fileExpression, boolean verbose) {
            String baseDirRegex;
            this.verbose = verbose;
            if (projectRelativeBaseDir == null || GitIgnore.GITIGNORE_PATH_SEPARATOR.equals(projectRelativeBaseDir) || projectRelativeBaseDir.trim().isEmpty()) {
                this.projectRelativeBaseDir = GitIgnore.GITIGNORE_PATH_SEPARATOR;
                baseDirRegex = "^/?";
            } else {
                this.projectRelativeBaseDir = (GitIgnore.GITIGNORE_PATH_SEPARATOR + projectRelativeBaseDir.trim() + GitIgnore.GITIGNORE_PATH_SEPARATOR).replaceAll("/+", GitIgnore.GITIGNORE_PATH_SEPARATOR);
                baseDirRegex = "^/?\\Q" + this.projectRelativeBaseDir.substring(1) + "\\E";
            }
            this.negate = negate;
            this.fileExpression = fileExpression;
            this.directoryMatch = !negate && fileExpression.endsWith(GitIgnore.GITIGNORE_PATH_SEPARATOR);
            String fileRegex = fileExpression.trim().replaceAll("^!", "").replace("[!", "[^");
            fileRegex = fileRegex.replace("?", "[^/]");
            if (fileExpression.contains(GitIgnore.GITIGNORE_PATH_SEPARATOR) && !fileExpression.endsWith(GitIgnore.GITIGNORE_PATH_SEPARATOR)) {
                if (fileRegex.startsWith(GitIgnore.GITIGNORE_PATH_SEPARATOR)) {
                    fileRegex = fileRegex.substring(1);
                }
            } else if (!Pattern.compile("./.").matcher(fileRegex).find()) {
                fileRegex = fileRegex.replaceAll("^([^/*])", "**/$1");
            }
            if ((fileRegex = fileRegex.replace("\\ ", " ").replace("$", "\\$").replace("(", "\\(").replace(")", "\\)")).contains("[") && fileRegex.contains(",")) {
                String newRegex;
                boolean changed = false;
                while (!(newRegex = fileRegex.replaceAll("\\[([^]]+) *, *([^]]+)]", "[$1|$2]")).equals(fileRegex)) {
                    fileRegex = newRegex;
                    changed = true;
                }
                if (changed) {
                    fileRegex = fileRegex.replaceAll("\\[([^]]+\\|[^]]+)]", "($1)");
                }
            }
            fileRegex = fileRegex.replaceAll("([^/*])$", "$1(/|\\$)").replace(".", "\\.").replace("\\.*", "\\..*").replace("?", ".").replaceAll("^\\*\\*/", "(.*/)?").replace("/**", "(/.*)?").replace("/*/", "/[^/]+/").replace("/*/", "/[^/]+/").replace("**", ".*").replaceAll("^\\*", ".*").replaceAll("^/", "^/").replaceAll("/\\*([^/]*)$", "/[^/]*$1\\$").replace("/*", "/.*").replaceAll("([^.\\]])\\*", "$1.*").replaceAll("/+", GitIgnore.GITIGNORE_PATH_SEPARATOR).replace("/\\E/", "/\\E");
            String finalRegex = baseDirRegex + fileRegex;
            try {
                this.filePattern = Pattern.compile(finalRegex);
                if (verbose) {
                    LOG.info("IgnoreRule for expression {}   -->   Regex {}", (Object)this.fileExpression, (Object)fileRegex);
                }
            }
            catch (PatternSyntaxException pse) {
                String errorMsg = "You either have an invalid gitignore rule (which you should fix) or you have found an edge case that should be fixed. In the latter case please file a bug report to https://github.com/nielsbasjes/codeowners/issues indicating that the expression >>>" + (negate ? "!" : "") + this.fileExpression + "<<< was converted to regex >>>" + finalRegex + "<<< which triggered the error: " + pse.getMessage();
                throw new PatternSyntaxException(errorMsg, finalRegex, pse.getIndex());
            }
        }

        public Boolean isIgnoredFile(String filename) {
            if (!this.filePattern.matcher(filename).find()) {
                if (this.verbose) {
                    LOG.info("NO MATCH     |{}| ~ |{}| --> |{}|", new Object[]{this.fileExpression, this.filePattern, filename});
                }
                return null;
            }
            if (this.negate) {
                if (this.verbose) {
                    LOG.info("MATCH NEGATE |{}| ~ |{}| --> |{}|", new Object[]{this.fileExpression, this.filePattern, filename});
                }
                return Boolean.FALSE;
            }
            if (this.verbose) {
                LOG.info("MATCH IGNORE |{}| ~ |{}| --> |{}|", new Object[]{this.fileExpression, this.filePattern, filename});
            }
            return Boolean.TRUE;
        }

        public boolean isDirectoryMatch() {
            return this.directoryMatch;
        }

        public String getIgnoreBasedir() {
            return this.projectRelativeBaseDir;
        }

        public String getIgnoreExpression() {
            return (this.negate ? "!" : "") + this.fileExpression;
        }

        public Pattern getIgnorePattern() {
            return this.filePattern;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public String toString() {
            return String.format("%-20s     # Used Regex: %s", (this.negate ? "!" : "") + this.fileExpression, this.filePattern);
        }
    }
}

