/*
 * Decompiled with CFR 0.152.
 */
package net.somta.juggle.core.http;

import feign.template.UriTemplate;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.somta.juggle.core.enums.ParameterPositionEnum;
import net.somta.juggle.core.enums.RequestTypeEnum;
import net.somta.juggle.core.model.InputParameter;
import net.somta.juggle.core.model.OutputParameter;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request {
    private static final Logger k = LoggerFactory.getLogger(Request.class);
    private String T;
    private String U;
    private RequestTypeEnum V;
    private Map<String, Object> W;
    private List<InputParameter> X;
    protected List<OutputParameter> Y;
    private Map<String, Object> Z;

    public Request(RequestTypeEnum requestType, List<InputParameter> inputParamSchemas, List<OutputParameter> outputParamSchemas) {
        this.V = requestType;
        this.X = inputParamSchemas;
        this.Y = outputParamSchemas;
    }

    public void initRequest(String apiCode, String requestUrl, Map<String, Object> headerData, Map<String, Object> inputParamData) {
        if (requestUrl == null) {
            throw new IllegalArgumentException("reqMethod,reqHeaders,reqBody should not be null");
        }
        this.T = apiCode;
        this.U = this.a(requestUrl, inputParamData);
        this.W = headerData;
        this.Z = this.b(inputParamData);
    }

    private String a(String apiUrl, Map<String, Object> inputParamData) {
        if (CollectionUtils.isEmpty(this.X)) {
            return apiUrl;
        }
        List pathInputParameterSchema = this.X.stream().filter(p -> ParameterPositionEnum.PATH.getCode().equals(p.getPosition())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pathInputParameterSchema)) {
            return apiUrl;
        }
        HashMap<String, Object> templateVariables = new HashMap<String, Object>();
        for (InputParameter inputParamSchema : pathInputParameterSchema) {
            Object value = inputParamData.get(inputParamSchema.getKey());
            templateVariables.put(inputParamSchema.getKey(), value);
        }
        UriTemplate template = UriTemplate.create((String)apiUrl, (Charset)StandardCharsets.UTF_8);
        apiUrl = template.expand(templateVariables);
        k.debug("request real url:" + apiUrl);
        return apiUrl;
    }

    private Map<String, Object> b(Map<String, Object> inputParamData) {
        if (CollectionUtils.isEmpty(this.X)) {
            return inputParamData;
        }
        List pathInputParameterSchema = this.X.stream().filter(p -> ParameterPositionEnum.PATH.getCode().equals(p.getPosition())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pathInputParameterSchema)) {
            return inputParamData;
        }
        for (InputParameter inputParamSchema : pathInputParameterSchema) {
            inputParamData.remove(inputParamSchema.getKey());
        }
        return inputParamData;
    }

    public String getApiCode() {
        return this.T;
    }

    public String getRequestUrl() {
        return this.U;
    }

    public RequestTypeEnum getRequestType() {
        return this.V;
    }

    public Map<String, Object> getRequestHeaders() {
        return this.W;
    }

    public List<InputParameter> getInputParamSchemas() {
        return this.X;
    }

    public Map<String, Object> getRequestParams() {
        return this.Z;
    }
}

