/*
 * Decompiled with CFR 0.152.
 */
package net.somta.juggle.core.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.somta.core.helper.JsonSerializeHelper;
import net.somta.juggle.core.enums.ParameterPositionEnum;
import net.somta.juggle.core.enums.RequestContentTypeEnum;
import net.somta.juggle.core.http.AbstractHttpClient;
import net.somta.juggle.core.http.IHttpClient;
import net.somta.juggle.core.http.Request;
import net.somta.juggle.core.model.InputParameter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class JsonHttpClient
extends AbstractHttpClient {
    private static volatile IHttpClient S;

    private JsonHttpClient() {
    }

    @Override
    protected String getRequestContentType() {
        return RequestContentTypeEnum.APPLICATION_JSON.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IHttpClient getHttpClientInstance() {
        if (S != null) return S;
        Class<JsonHttpClient> clazz = JsonHttpClient.class;
        synchronized (JsonHttpClient.class) {
            if (S != null) return S;
            S = new JsonHttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return S;
        }
    }

    @Override
    protected void e(HttpUriRequestBase httpRequest, Request request) {
        if (request.getRequestParams() != null) {
            List<InputParameter> inputParamSchemas = request.getInputParamSchemas();
            this.a(httpRequest, request, inputParamSchemas);
            List bodyInputParameterSchema = inputParamSchemas.stream().filter(p -> ParameterPositionEnum.BODY.getCode().equals(p.getPosition())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(bodyInputParameterSchema)) {
                HashMap<String, Object> bodyParamsMap = new HashMap<String, Object>();
                for (InputParameter inputParamSchema : bodyInputParameterSchema) {
                    Object value = request.getRequestParams().get(inputParamSchema.getKey());
                    bodyParamsMap.put(inputParamSchema.getKey(), value);
                }
                try {
                    String jsonBodyParam = JsonSerializeHelper.serialize(bodyParamsMap);
                    StringEntity stringEntity = new StringEntity(jsonBodyParam, ContentType.APPLICATION_JSON);
                    httpRequest.setEntity((HttpEntity)stringEntity);
                }
                catch (JsonProcessingException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }
}

