/*
 * Decompiled with CFR 0.152.
 */
package net.somta.juggle.core.http;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.somta.juggle.core.enums.ParameterPositionEnum;
import net.somta.juggle.core.enums.RequestContentTypeEnum;
import net.somta.juggle.core.http.AbstractHttpClient;
import net.somta.juggle.core.http.IHttpClient;
import net.somta.juggle.core.http.Request;
import net.somta.juggle.core.model.InputParameter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class FormHttpClient
extends AbstractHttpClient {
    private static volatile IHttpClient R;

    private FormHttpClient() {
    }

    @Override
    protected String getRequestContentType() {
        return RequestContentTypeEnum.APPLICATION_FORM_URLENCODED.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IHttpClient getHttpClientInstance() {
        if (R != null) return R;
        Class<FormHttpClient> clazz = FormHttpClient.class;
        synchronized (FormHttpClient.class) {
            if (R != null) return R;
            R = new FormHttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return R;
        }
    }

    @Override
    protected void e(HttpUriRequestBase httpRequest, Request request) {
        if (request.getRequestParams() != null) {
            List<InputParameter> inputParamSchemas = request.getInputParamSchemas();
            this.a(httpRequest, request, inputParamSchemas);
            List bodyInputParameterSchema = inputParamSchemas.stream().filter(p -> ParameterPositionEnum.BODY.getCode().equals(p.getPosition())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(bodyInputParameterSchema)) {
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                for (InputParameter inputParamSchema : bodyInputParameterSchema) {
                    Object value = request.getRequestParams().get(inputParamSchema.getKey());
                    params.add(new BasicNameValuePair(inputParamSchema.getKey(), String.valueOf(value)));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
                httpRequest.setEntity((HttpEntity)entity);
            }
        }
    }
}

