/*
 * Decompiled with CFR 0.152.
 */
package net.somta.juggle.core.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.somta.core.helper.JsonSerializeHelper;
import net.somta.juggle.core.enums.ParameterPositionEnum;
import net.somta.juggle.core.enums.RequestTypeEnum;
import net.somta.juggle.core.http.IHttpClient;
import net.somta.juggle.core.http.Request;
import net.somta.juggle.core.model.InputParameter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClient
implements IHttpClient {
    private static final Logger k = LoggerFactory.getLogger(AbstractHttpClient.class);
    private PoolingHttpClientConnectionManager Q = new PoolingHttpClientConnectionManager();

    public AbstractHttpClient() {
        this.Q.setMaxTotal(200);
        this.Q.setDefaultMaxPerRoute(80);
        this.Q.setConnectionConfigResolver(route -> ConnectionConfig.custom().setValidateAfterInactivity((TimeValue)Timeout.ofSeconds((long)10L)).build());
    }

    @Override
    public Map<String, Object> sendRequest(Request request) {
        HttpGet httpRequest = null;
        if (request.getRequestType() == RequestTypeEnum.GET) {
            httpRequest = new HttpGet(request.getRequestUrl());
        } else if (request.getRequestType() == RequestTypeEnum.DELETE) {
            httpRequest = new HttpDelete(request.getRequestUrl());
        } else if (request.getRequestType() == RequestTypeEnum.PUT) {
            httpRequest = new HttpPut(request.getRequestUrl());
        } else if (request.getRequestType() == RequestTypeEnum.POST) {
            httpRequest = new HttpPost(request.getRequestUrl());
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u7c7b\u578b");
        }
        this.e((HttpUriRequestBase)httpRequest, request);
        this.a((HttpUriRequestBase)httpRequest, request);
        this.c((HttpUriRequestBase)httpRequest, request);
        return this.d((HttpUriRequestBase)httpRequest, request);
    }

    private void a(HttpUriRequestBase httpRequest, Request request) {
        this.b(httpRequest, request);
        Map<String, Object> headers = request.getRequestHeaders();
        if (headers != null) {
            for (Map.Entry<String, Object> header : headers.entrySet()) {
                httpRequest.addHeader(header.getKey(), header.getValue());
            }
        }
    }

    private void b(HttpUriRequestBase httpRequest, Request request) {
        httpRequest.addHeader("Content-Type", (Object)this.getRequestContentType());
        Package pkg = AbstractHttpClient.class.getPackage();
        String version = pkg.getImplementationVersion();
        if (StringUtils.isNotBlank((CharSequence)version)) {
            httpRequest.addHeader("Juggle-Version", (Object)version);
        }
        String apiKey = System.getProperty("apiKey");
        httpRequest.addHeader("Api-Key", (Object)apiKey);
        httpRequest.addHeader("Api-Code", (Object)request.getApiCode());
    }

    private void c(HttpUriRequestBase httpRequest, Request request) {
        RequestConfig.Builder builder = RequestConfig.custom();
        httpRequest.setConfig(builder.build());
    }

    protected void a(HttpUriRequestBase httpRequest, Request request, List<InputParameter> inputParamSchemas) {
        List queryInputParameterSchema = inputParamSchemas.stream().filter(p -> ParameterPositionEnum.QUERY.getCode().equals(p.getPosition())).collect(Collectors.toList());
        ArrayList<BasicNameValuePair> queryParamsList = new ArrayList<BasicNameValuePair>();
        if (!CollectionUtils.isEmpty(queryInputParameterSchema)) {
            for (InputParameter inputParamSchema : queryInputParameterSchema) {
                Object value = request.getRequestParams().get(inputParamSchema.getKey());
                queryParamsList.add(new BasicNameValuePair(inputParamSchema.getKey(), String.valueOf(value)));
            }
            try {
                URI uri = new URIBuilder(new URI(request.getRequestUrl())).addParameters(queryParamsList).build();
                httpRequest.setUri(uri);
            }
            catch (URISyntaxException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private Map<String, Object> d(HttpUriRequestBase httpRequest, Request request) {
        Map<String, Object> resultMap = new HashMap<String, Object>(8);
        HttpClientResponseHandler responseHandler = response -> {
            int statusCode = response.getCode();
            if (statusCode >= 300) {
                k.error("\u8bf7\u6c42\u63a5\u53e3\u5f02\u5e38\uff0c\u63a5\u53e3\u5730\u5740:{},\u54cd\u5e94\u72b6\u6001\u7801\uff1a{}", (Object)request.getRequestUrl(), (Object)statusCode);
                return Collections.EMPTY_MAP;
            }
            HttpEntity entity = response.getEntity();
            String resultContent = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            k.debug("http url:{}, result:{}", (Object)request.getRequestUrl(), (Object)resultContent);
            Map map = (Map)JsonSerializeHelper.deserialize((String)resultContent, Map.class);
            if (entity != null) {
                EntityUtils.consume((HttpEntity)entity);
            }
            return map;
        };
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.Q).build();
        try {
            resultMap = (Map)httpClient.execute((ClassicHttpRequest)httpRequest, responseHandler);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return resultMap;
    }

    protected abstract String getRequestContentType();

    protected abstract void e(HttpUriRequestBase var1, Request var2);
}

