/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;

public class SqlUtil {
    private static final char MARK = '?';
    private static final Set<String> NOT_NEED_BRACKETS;
    private static final Set<String> NEED_BRACKETS;

    public static StringBuilder parseSql(String sql, Queue<Map.Entry<String, String>> params) {
        StringBuilder sb = new StringBuilder(sql);
        for (int i = 0; i < sb.length(); ++i) {
            Map.Entry<String, String> param;
            if (sb.charAt(i) != '?' || Objects.isNull(param = params.poll())) continue;
            sb.deleteCharAt(i);
            if (NOT_NEED_BRACKETS.contains(param.getKey())) {
                sb.insert(i, param.getValue());
                continue;
            }
            sb.insert(i, String.format("'%s'", param.getValue()));
        }
        return sb;
    }

    public static StringBuilder parseSql(String sql, Object ... params) {
        StringBuilder sb = new StringBuilder(sql);
        if (Objects.isNull(params)) {
            return sb;
        }
        LinkedList queue = new LinkedList();
        Collections.addAll(queue, params);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '?') continue;
            Object param = queue.poll();
            sb.deleteCharAt(i);
            if (Objects.isNull(param)) {
                sb.insert(i, "null");
                continue;
            }
            if (NEED_BRACKETS.contains(param.getClass().getSimpleName())) {
                sb.insert(i, String.format("'%s'", param));
                continue;
            }
            sb.insert(i, param);
        }
        return sb;
    }

    static {
        HashSet<String> types = new HashSet<String>(1);
        types.add("number");
        NOT_NEED_BRACKETS = Collections.unmodifiableSet(types);
        types = new HashSet(9);
        types.add("String");
        types.add("Date");
        types.add("Time");
        types.add("LocalDate");
        types.add("LocalTime");
        types.add("LocalDateTime");
        types.add("BigDecimal");
        types.add("Timestamp");
        types.add("DateTime");
        NEED_BRACKETS = Collections.unmodifiableSet(types);
    }
}

