/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.entity;

import cn.hutool.json.JSONUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.HttpStatus;

public class ResultData
extends HashMap<String, Object> {
    public static final String CODE_KEY = "code";
    public static final String DATA_KEY = "data";
    public static final String MSG_KEY = "msg";
    public static final String RESULT_KEY = "result";

    public static ResultData build() {
        return new ResultData();
    }

    public ResultData code(HttpStatus code) {
        return this.add(RESULT_KEY, code == HttpStatus.OK).add(CODE_KEY, code.value());
    }

    public ResultData code(String code) {
        return this.add(RESULT_KEY, code.equalsIgnoreCase(HttpStatus.OK.toString())).add(CODE_KEY, code);
    }

    public ResultData msg(String msg) {
        return this.add(MSG_KEY, msg);
    }

    public ResultData data(Object data) {
        return this.add(DATA_KEY, data);
    }

    public ResultData success() {
        return this.code(HttpStatus.OK);
    }

    public ResultData success(Object data) {
        return this.success().data(data);
    }

    public ResultData success(String msg, Object data) {
        return this.success().msg(msg).data(data);
    }

    public ResultData error() {
        return this.code(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public ResultData error(String msg) {
        return this.error().msg(msg);
    }

    public ResultData add(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public <T> T getData(Class<T> c) {
        Object obj = this.get(DATA_KEY);
        if (obj instanceof Map) {
            return (T)JSONUtil.toBean((String)JSONUtil.toJsonStr(obj), c);
        }
        return (T)obj;
    }

    public String getMsg() {
        return Objects.isNull(this.get(MSG_KEY)) ? "" : this.get(MSG_KEY).toString();
    }

    public int getCode() {
        return Integer.parseInt("" + this.get(CODE_KEY));
    }

    public boolean isSuccess() {
        return Boolean.parseBoolean("" + this.get(RESULT_KEY));
    }
}

