/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.biz;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.extra.spring.SpringUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mingsoft.base.biz.SqlQueryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public interface ISqlAdapter {
    public static final Logger LOG = LoggerFactory.getLogger(ISqlAdapter.class);

    default public void handleEq(StringBuffer sb, SqlQueryWrapper.SqlWhere sqlWhere) {
        if (sqlWhere.getMultiple().booleanValue()) {
            sb.append("FIND_IN_SET(?, ").append(sqlWhere.getField()).append(")>0");
        } else {
            sb.append(sqlWhere.getField());
            sb.append(" = ?");
        }
    }

    default public void handleGt(StringBuffer sb, SqlQueryWrapper.SqlWhere sqlWhere) {
        String type = sqlWhere.getType();
        String field = sqlWhere.getField();
        if ("date".equals(type) || "time".equals(type)) {
            if ("time".equals(type)) {
                sb.append(" DATE_FORMAT(").append(field).append(", '%T')").append(" > ").append("DATE_FORMAT(?, '%T')");
            }
            if ("date".equals(type)) {
                sb.append(" DATE_FORMAT(").append(field).append(", '%Y-%m-%d %H:%i:%s')").append(" > ").append("DATE_FORMAT(?, '%Y-%m-%d %H:%i:%s')");
            }
        } else {
            sb.append(field);
            sb.append(" > ?");
        }
    }

    default public void handleGet(StringBuffer sb, SqlQueryWrapper.SqlWhere sqlWhere) {
        sb.append(sqlWhere.getField());
        sb.append(" >= ?");
    }

    default public void handleLt(StringBuffer sb, SqlQueryWrapper.SqlWhere sqlWhere) {
        String type = sqlWhere.getType();
        String field = sqlWhere.getField();
        if ("date".equals(type) || "time".equals(type)) {
            if ("time".equals(type)) {
                sb.append(" DATE_FORMAT(").append(field).append(", '%T')").append(" < ").append("DATE_FORMAT(?, '%T')");
            }
            if ("date".equals(type)) {
                sb.append(" DATE_FORMAT(").append(field).append(", '%Y-%m-%d %H:%i:%s')").append(" < ").append("DATE_FORMAT(?, '%Y-%m-%d %H:%i:%s')");
            }
        } else {
            sb.append(field);
            sb.append(" < ?");
        }
    }

    default public void handleLet(StringBuffer sb, SqlQueryWrapper.SqlWhere sqlWhere) {
        sb.append(sqlWhere.getField());
        sb.append(" <= ?");
    }

    default public void handleLike(StringBuffer sb, SqlQueryWrapper.SqlWhere sqlWhere) {
        sb.append(sqlWhere.getField());
        sb.append(" LIKE ").append("CONCAT('%', ?, '%')");
    }

    default public void handleLikeLeft(StringBuffer sb, SqlQueryWrapper.SqlWhere sqlWhere) {
        sb.append(sqlWhere.getField());
        sb.append(" LIKE ").append("CONCAT('%', ?)");
    }

    default public void handleLikeRight(StringBuffer sb, SqlQueryWrapper.SqlWhere sqlWhere) {
        sb.append(sqlWhere.getField());
        sb.append(" LIKE ").append("CONCAT(?, '%')");
    }

    default public void handleIn(StringBuffer sb, SqlQueryWrapper.SqlWhere sqlWhere) {
        sb.append(sqlWhere.getField());
        sb.append(" IN ").append("(?)");
    }

    default public void handleRange(StringBuffer sb, SqlQueryWrapper.SqlWhere sqlWhere) {
        String type = sqlWhere.getType();
        String field = sqlWhere.getField();
        if ("time".equals(type)) {
            sb.append(" DATE_FORMAT(").append(field).append(", '%T')").append(" BETWEEN ").append("DATE_FORMAT(?, '%T')").append(" AND DATE_FORMAT(?, '%T')");
        } else if ("date".equals(type)) {
            sb.append(" DATE_FORMAT(").append(field).append(", '%Y-%m-%d %H:%i:%s')").append(" BETWEEN ").append("DATE_FORMAT(?, '%Y-%m-%d %H:%i:%s')").append(" AND DATE_FORMAT(?, '%Y-%m-%d %H:%i:%s')");
        } else {
            sb.append(field);
            sb.append(" BETWEEN ? AND ?");
        }
    }

    default public int handlePage(StringBuffer querySql, int start, int size, List params) {
        String countSql = "SELECT COUNT(*) AS TOTAL FROM (" + querySql.toString() + ") AS sub";
        LOG.debug("countSql:{}", (Object)countSql);
        Map totalMap = null;
        totalMap = ArrayUtil.isAllNotEmpty((Object[])new Object[]{params}) ? ((JdbcTemplate)SpringUtil.getBean(JdbcTemplate.class)).queryForMap(countSql, params.toArray()) : ((JdbcTemplate)SpringUtil.getBean(JdbcTemplate.class)).queryForMap(countSql);
        querySql.append(" LIMIT ?, ?");
        params.add(start);
        params.add(size);
        return Integer.parseInt(totalMap.get("TOTAL").toString());
    }

    default public void handleOrderByDesc(StringBuffer querySql, String column) {
        boolean isOrderBy = querySql.toString().toLowerCase().contains("order by");
        if (!isOrderBy) {
            querySql.append(" ORDER BY ").append(column).append(" DESC");
        } else {
            querySql.append(", ").append(column).append(" DESC");
        }
    }

    default public void handleOrderByAsc(StringBuffer querySql, String column) {
        boolean isOrderBy = querySql.toString().toLowerCase().contains("order by");
        if (!isOrderBy) {
            querySql.append(" ORDER BY ").append(column).append(" ASC");
        } else {
            querySql.append(", ").append(column).append(" ASC");
        }
    }

    default public String handleTime(String type) {
        return "?";
    }

    default public List<String> queryTables() {
        String preSql = "SELECT table_name FROM information_schema.TABLES WHERE table_schema = (select database()) AND table_type = 'BASE TABLE'";
        List tableNameListMaps = ((JdbcTemplate)SpringUtil.getBean(JdbcTemplate.class)).queryForList(preSql);
        return tableNameListMaps.stream().map(map -> map.get("table_name").toString()).collect(Collectors.toList());
    }

    default public List<String> queryTableColumns(String tableName) {
        String preSql = "SELECT column_name FROM information_schema.COLUMNS  WHERE TABLE_SCHEMA = (select database()) AND TABLE_NAME = ? ";
        List tableColumnsListMaps = ((JdbcTemplate)SpringUtil.getBean(JdbcTemplate.class)).queryForList(preSql, new Object[]{tableName});
        return tableColumnsListMaps.stream().map(map -> map.get("column_name").toString()).collect(Collectors.toList());
    }
}

