/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.util;

import cn.hutool.extra.servlet.JakartaServletUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mingsoft.base.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SqlInjectionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SqlInjectionUtil.class);
    private static final String REG = "(exec|insert|alter|select|drop|grant|delete|update|count|chr|mid|master|truncate|char|declare|or|updatexml|extractvalue|floor|exp|linestring|multpolygon|multlinestring|multipoint|polygon|GeometryCollection|name_const|current_user|if|exists|dumpfile|outfile)|(<|>)|(\\*|;|\\+|'|%)\\n";
    private static final String SQL_SYMBOL_REG = ";|\\(|\\)|/\\*![\\s\\S]*?\\*/";
    private static final Pattern sqlPattern = Pattern.compile("(exec|insert|alter|select|drop|grant|delete|update|count|chr|mid|master|truncate|char|declare|or|updatexml|extractvalue|floor|exp|linestring|multpolygon|multlinestring|multipoint|polygon|GeometryCollection|name_const|current_user|if|exists|dumpfile|outfile)|(<|>)|(\\*|;|\\+|'|%)\\n", 2);
    private static final Pattern sqlSymbolPattern = Pattern.compile(";|\\(|\\)|/\\*![\\s\\S]*?\\*/", 2);

    public static void filterContent(String ... values) {
        for (String value : values) {
            if (value == null || "".equals(value) || SqlInjectionUtil.isSqlValid(value)) continue;
            HttpServletRequest request = null;
            String clientIP = null;
            String url = null;
            try {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                clientIP = JakartaServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
                url = request.getRequestURL().toString();
            }
            catch (Exception e) {
                LOG.debug("\u901a\u8fc7request\u83b7\u53d6ip,url\u5f02\u5e38");
                e.printStackTrace();
            }
            LOG.debug("log error\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669: {}  \u5f53\u524d\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}\uff0cip\u4e3a\uff1a{}", new Object[]{value, url, clientIP});
            throw new BusinessException("\u8bf7\u6c42\u5730\u5740:" + SqlInjectionUtil.getRequestUrl() + " \n \u5f53\u524d\u64cd\u4f5c\u5b58\u5728sql\u6ce8\u5165\u98ce\u9669\uff0cbad sql word:" + value);
        }
    }

    public static void filterContent(Map<String, String> fields) {
        Iterator<String> iterator = fields.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            String value = fields.get(key);
            LOG.debug("key:{} value:{}", (Object)key, (Object)value);
            SqlInjectionUtil.filterContent(key);
            SqlInjectionUtil.filterContent(value);
        }
    }

    public static boolean isSqlValid(String str) {
        Matcher matcher = sqlPattern.matcher(str);
        if (matcher.find()) {
            Matcher symbolMatcher;
            String sqlRegGroup = "";
            if (StringUtils.isNotBlank((CharSequence)matcher.group())) {
                sqlRegGroup = matcher.group();
            }
            if ((symbolMatcher = sqlSymbolPattern.matcher(str)).find()) {
                String sqlSymbolGroup = "";
                if (StringUtils.isNotBlank((CharSequence)symbolMatcher.group())) {
                    sqlSymbolGroup = symbolMatcher.group();
                }
                LOG.info("\u53c2\u6570\u5b58\u5728\u975e\u6cd5\u5b57\u7b26: {}\uff0c\u5b58\u5728sql\u7b26\u53f7\u7279\u5f81: {}\uff0c\u8bf7\u786e\u8ba4", (Object)sqlRegGroup, (Object)sqlSymbolGroup);
                return false;
            }
        }
        return true;
    }

    public static String getRequestUrl() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        StringBuffer requestURL = request.getRequestURL();
        return requestURL.toString();
    }
}

