/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.ltgt.gradle.apt.AptPlugin212to214;
import net.ltgt.gradle.apt.AptPlugin25to211;
import net.ltgt.gradle.apt.AptPlugin30to33;
import net.ltgt.gradle.apt.AptPlugin34;
import net.ltgt.gradle.apt.AptPlugin35to42;
import net.ltgt.gradle.apt.AptPlugin43to44;
import net.ltgt.gradle.apt.AptPlugin45;
import net.ltgt.gradle.apt.AptPlugin46to48;
import net.ltgt.gradle.apt.AptPlugin49;
import net.ltgt.gradle.apt.DeprecationLogger;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;

public class AptPlugin
implements Plugin<Project> {
    static final String PLUGIN_ID = "net.ltgt.apt";
    static final Impl IMPL = Impl.newInstance();

    public void apply(final Project project) {
        this.configureCompileTasks(project, JavaCompile.class, new GetCompileOptions<JavaCompile>(){

            @Override
            public CompileOptions getCompileOptions(JavaCompile task) {
                return task.getOptions();
            }
        });
        this.configureCompileTasks(project, GroovyCompile.class, new GetCompileOptions<GroovyCompile>(){

            @Override
            public CompileOptions getCompileOptions(GroovyCompile task) {
                return task.getOptions();
            }
        });
        project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaBasePlugin) {
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                javaConvention.getSourceSets().all((Action)new Action<SourceSet>(){

                    public void execute(SourceSet sourceSet) {
                        AptSourceSetConvention convention = IMPL.createAptSourceSetConvention(project, sourceSet);
                        ((HasConvention)sourceSet).getConvention().getPlugins().put(AptPlugin.PLUGIN_ID, convention);
                        AptSourceSetOutputConvention outputConvention = new AptSourceSetOutputConvention(project);
                        outputConvention.setGeneratedSourcesDir(new File(project.getBuildDir(), "generated/source/apt/" + sourceSet.getName()));
                        ((HasConvention)sourceSet.getOutput()).getConvention().getPlugins().put(AptPlugin.PLUGIN_ID, outputConvention);
                        AptPlugin.this.ensureConfigurations(project, sourceSet, convention);
                        AptPlugin.this.configureCompileTaskForSourceSet(project, sourceSet, sourceSet.getCompileJavaTaskName(), JavaCompile.class, new GetCompileOptions<JavaCompile>(){

                            @Override
                            public CompileOptions getCompileOptions(JavaCompile task) {
                                return task.getOptions();
                            }
                        });
                    }
                });
            }
        });
        project.getPlugins().withType(GroovyBasePlugin.class, (Action)new Action<GroovyBasePlugin>(){

            public void execute(GroovyBasePlugin groovyBasePlugin) {
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                javaConvention.getSourceSets().all((Action)new Action<SourceSet>(){

                    public void execute(SourceSet sourceSet) {
                        AptSourceSetConvention convention = (AptSourceSetConvention)((HasConvention)sourceSet).getConvention().getPlugin(AptSourceSetConvention.class);
                        AptPlugin.this.configureCompileTaskForSourceSet(project, sourceSet, sourceSet.getCompileTaskName("groovy"), GroovyCompile.class, new GetCompileOptions<GroovyCompile>(){

                            @Override
                            public CompileOptions getCompileOptions(GroovyCompile task) {
                                return task.getOptions();
                            }
                        });
                    }
                });
            }
        });
    }

    private <T extends AbstractCompile> void configureCompileTasks(final Project project, Class<T> compileTaskClass, final GetCompileOptions<T> getCompileOptions) {
        IMPL.configureTasks(project, compileTaskClass, new Action<T>(){

            public void execute(T task) {
                CompileOptions compileOptions = getCompileOptions.getCompileOptions(task);
                task.getConvention().getPlugins().put(AptPlugin.PLUGIN_ID, IMPL.createAptConvention(project, (AbstractCompile)task, compileOptions));
                IMPL.addExtension(task.getExtensions(), AptOptions.class, "aptOptions", IMPL.createAptOptions(project, (AbstractCompile)task, compileOptions));
                IMPL.configureCompileTask(project, (AbstractCompile)task, compileOptions);
            }
        });
    }

    private void ensureConfigurations(Project project, SourceSet sourceSet, AptSourceSetConvention convention) {
        IMPL.ensureCompileOnlyConfiguration(project, sourceSet, convention);
        Configuration annotationProcessorConfiguration = IMPL.ensureAnnotationProcessorConfiguration(project, sourceSet, convention);
        convention.setAnnotationProcessorPath((FileCollection)annotationProcessorConfiguration);
        this.createAptConfiguration(project, sourceSet, convention, annotationProcessorConfiguration);
    }

    private void createAptConfiguration(final Project project, SourceSet sourceSet, AptSourceSetConvention convention, final Configuration annotationProcessorConfiguration) {
        final Configuration aptConfiguration = (Configuration)project.getConfigurations().create(convention.getAptConfigurationName());
        aptConfiguration.setVisible(false);
        aptConfiguration.setDescription("Processor path for " + sourceSet.getName() + ". Deprecated, please use the " + annotationProcessorConfiguration.getName() + " configuration instead.");
        aptConfiguration.getDependencies().whenObjectAdded((Action)new Action<Dependency>(){

            public void execute(Dependency dependency) {
                DeprecationLogger.nagUserWith(project, "The " + aptConfiguration.getName() + " configuration has been deprecated. Please use the " + annotationProcessorConfiguration.getName() + " configuration instead.");
            }
        });
        annotationProcessorConfiguration.extendsFrom(new Configuration[]{aptConfiguration});
    }

    private <T extends AbstractCompile> void configureCompileTaskForSourceSet(final Project project, final SourceSet sourceSet, String compileTaskName, Class<T> compileTaskClass, final GetCompileOptions<T> getCompileOptions) {
        IMPL.configureTask(project, compileTaskClass, compileTaskName, new Action<T>(){

            public void execute(T task) {
                IMPL.configureCompileTaskForSourceSet(project, sourceSet, (AbstractCompile)task, getCompileOptions.getCompileOptions(task));
            }
        });
    }

    public static class AptSourceSetOutputConvention {
        private final Project project;
        @Nullable
        private Object generatedSourcesDir;

        public AptSourceSetOutputConvention(Project project) {
            this.project = project;
        }

        @Nullable
        public File getGeneratedSourcesDir() {
            if (this.generatedSourcesDir == null) {
                return null;
            }
            return this.project.file(this.generatedSourcesDir);
        }

        public void setGeneratedSourcesDir(@Nullable Object generatedSourcesDir) {
            this.generatedSourcesDir = generatedSourcesDir;
        }
    }

    public static abstract class AptSourceSetConvention {
        static final String PROCESSORPATH_DEPRECATION_MESSAGE = "The processorpath property has been deprecated. Please use the annotationProcessorPath property instead.";
        protected final Project project;
        protected final SourceSet sourceSet;

        public AptSourceSetConvention(Project project, SourceSet sourceSet) {
            this.project = project;
            this.sourceSet = sourceSet;
        }

        @Nullable
        public abstract FileCollection getAnnotationProcessorPath();

        public abstract void setAnnotationProcessorPath(@Nullable FileCollection var1);

        @Nullable
        @Deprecated
        public FileCollection getProcessorpath() {
            DeprecationLogger.nagUserWith(this.project, "sourceSets." + this.sourceSet.getName() + ": " + PROCESSORPATH_DEPRECATION_MESSAGE);
            return this.getAnnotationProcessorPath();
        }

        @Deprecated
        public void setProcessorpath(@Nullable Object processorpath) {
            DeprecationLogger.nagUserWith(this.project, "sourceSets." + this.sourceSet.getName() + ": " + PROCESSORPATH_DEPRECATION_MESSAGE);
            if (processorpath == null || processorpath instanceof FileCollection) {
                this.setAnnotationProcessorPath((FileCollection)processorpath);
            } else {
                this.setAnnotationProcessorPath((FileCollection)this.project.files(new Object[]{processorpath}));
            }
        }

        public abstract String getCompileOnlyConfigurationName();

        @Deprecated
        public String getAptConfigurationName() {
            return this.sourceSet.getTaskName("", "apt");
        }

        public abstract String getAnnotationProcessorConfigurationName();
    }

    public static abstract class AptOptions {
        private boolean annotationProcessing = true;
        @Nullable
        private List<?> processors = new ArrayList();
        @Nullable
        private Map<String, ?> processorArgs = new LinkedHashMap();

        @Input
        public boolean isAnnotationProcessing() {
            return this.annotationProcessing;
        }

        public void setAnnotationProcessing(boolean annotationProcessing) {
            this.annotationProcessing = annotationProcessing;
        }

        @Internal
        @Nullable
        public abstract FileCollection getProcessorpath();

        public abstract void setProcessorpath(@Nullable Object var1);

        @Input
        @Optional
        @Nullable
        public List<?> getProcessors() {
            return this.processors;
        }

        public void setProcessors(@Nullable List<?> processors) {
            this.processors = processors;
        }

        @Input
        @Optional
        @Nullable
        public Map<String, ?> getProcessorArgs() {
            return this.processorArgs;
        }

        public void setProcessorArgs(@Nullable Map<String, ?> processorArgs) {
            this.processorArgs = processorArgs;
        }

        protected List<String> asArguments() {
            ArrayList<String> arguments = new ArrayList<String>();
            if (!this.annotationProcessing) {
                arguments.add("-proc:none");
            }
            if (this.processors != null && !this.processors.isEmpty()) {
                arguments.add("-processor");
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Object processor : this.processors) {
                    if (!first) {
                        sb.append(',');
                    } else {
                        first = false;
                    }
                    sb.append(processor);
                }
                arguments.add(sb.toString());
            }
            if (this.processorArgs != null) {
                for (Map.Entry<String, ?> entry : this.processorArgs.entrySet()) {
                    arguments.add("-A" + entry.getKey() + "=" + entry.getValue());
                }
            }
            return arguments;
        }
    }

    public static abstract class AptConvention {
        @Nullable
        public abstract File getGeneratedSourcesDestinationDir();

        public abstract void setGeneratedSourcesDestinationDir(@Nullable Object var1);
    }

    static abstract class Impl {
        Impl() {
        }

        static Impl newInstance() {
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.9")) >= 0) {
                return new AptPlugin49();
            }
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.6")) >= 0) {
                return new AptPlugin46to48();
            }
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.5")) >= 0) {
                return new AptPlugin45();
            }
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.3")) >= 0) {
                return new AptPlugin43to44();
            }
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"3.5")) >= 0) {
                return new AptPlugin35to42();
            }
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"3.4")) >= 0) {
                return new AptPlugin34();
            }
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"3.0")) >= 0) {
                return new AptPlugin30to33();
            }
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"2.12")) >= 0) {
                return new AptPlugin212to214();
            }
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"2.5")) >= 0) {
                return new AptPlugin25to211();
            }
            throw new UnsupportedOperationException();
        }

        protected abstract <T extends Task> Object createTask(Project var1, String var2, Class<T> var3, Action<T> var4);

        protected abstract <T extends Task> void configureTasks(Project var1, Class<T> var2, Action<T> var3);

        protected abstract <T extends Task> void configureTask(Project var1, Class<T> var2, String var3, Action<T> var4);

        protected abstract <T> void addExtension(ExtensionContainer var1, Class<T> var2, String var3, T var4);

        protected abstract AptConvention createAptConvention(Project var1, AbstractCompile var2, CompileOptions var3);

        protected abstract AptOptions createAptOptions(Project var1, AbstractCompile var2, CompileOptions var3);

        protected abstract void configureCompileTask(Project var1, AbstractCompile var2, CompileOptions var3);

        protected abstract AptSourceSetConvention createAptSourceSetConvention(Project var1, SourceSet var2);

        protected abstract void ensureCompileOnlyConfiguration(Project var1, SourceSet var2, AptSourceSetConvention var3);

        protected abstract Configuration ensureAnnotationProcessorConfiguration(Project var1, SourceSet var2, AptSourceSetConvention var3);

        protected abstract void configureCompileTaskForSourceSet(Project var1, SourceSet var2, AbstractCompile var3, CompileOptions var4);

        abstract String getAnnotationProcessorConfigurationName(SourceSet var1);

        abstract String getCompileOnlyConfigurationName(SourceSet var1);
    }

    private static interface GetCompileOptions<T extends AbstractCompile> {
        public CompileOptions getCompileOptions(T var1);
    }
}

