/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.ltgt.gradle.apt.AptPlugin;
import net.ltgt.gradle.apt.EclipseFactorypath;
import net.ltgt.gradle.apt.EclipseJdtApt;
import net.ltgt.gradle.apt.GenerateEclipseFactorypath;
import net.ltgt.gradle.apt.GenerateEclipseJdtApt;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.PropertiesTransformer;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.api.PropertiesFileContentMerger;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;

public class AptEclipsePlugin
implements Plugin<Project> {
    private final Instantiator instantiator;

    private static Action<Task> dependsOn(final Object taskDependency) {
        return new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{taskDependency});
            }
        };
    }

    @Inject
    public AptEclipsePlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(final Project project) {
        project.getPlugins().apply(AptPlugin.class);
        project.getPlugins().apply(EclipsePlugin.class);
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
                SourceSet testSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("test");
                AptEclipsePlugin.this.configureEclipse(project, mainSourceSet, testSourceSet);
            }
        });
    }

    private void configureEclipse(Project project, final SourceSet mainSourceSet, final SourceSet testSourceSet) {
        final EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                eclipseModel.getClasspath().getPlusConfigurations().addAll(Arrays.asList(project.getConfigurations().getByName(AptPlugin.IMPL.getCompileOnlyConfigurationName(mainSourceSet)), project.getConfigurations().getByName(AptPlugin.IMPL.getCompileOnlyConfigurationName(testSourceSet))));
            }
        });
        this.configureJdtApt(project, eclipseModel, mainSourceSet);
        this.configureFactorypath(project, eclipseModel, mainSourceSet, testSourceSet);
    }

    private void configureJdtApt(final Project project, EclipseModel eclipseModel, final SourceSet mainSourceSet) {
        final EclipseJdtApt jdtApt = (EclipseJdtApt)this.instantiator.newInstance(EclipseJdtApt.class, new Object[]{project, new PropertiesFileContentMerger(new PropertiesTransformer())});
        ((ExtensionAware)eclipseModel.getJdt()).getExtensions().add("apt", (Object)jdtApt);
        ConventionMapping conventionMapping = ((IConventionAware)jdtApt).getConventionMapping();
        conventionMapping.map("aptEnabled", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((AptPlugin.AptOptions)project.getTasks().getByName(mainSourceSet.getCompileJavaTaskName()).getExtensions().getByType(AptPlugin.AptOptions.class)).isAnnotationProcessing();
            }
        });
        conventionMapping.map("genSrcDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return project.file((Object)".apt_generated");
            }
        });
        conventionMapping.map("processorOptions", new Callable<Map<String, ?>>(){

            @Override
            @Nullable
            public Map<String, ?> call() throws Exception {
                return ((AptPlugin.AptOptions)project.getTasks().getByName(mainSourceSet.getCompileJavaTaskName()).getExtensions().getByType(AptPlugin.AptOptions.class)).getProcessorArgs();
            }
        });
        eclipseModel.getJdt().getFile().withProperties((Closure)new MethodClosure((Object)new Action<Properties>(){

            public void execute(Properties properties) {
                properties.setProperty("org.eclipse.jdt.core.compiler.processAnnotations", jdtApt.isAptEnabled() ? "enabled" : "disabled");
            }
        }, "execute"));
        final Object task = AptPlugin.IMPL.createTask(project, "eclipseJdtApt", GenerateEclipseJdtApt.class, new Action<GenerateEclipseJdtApt>(){

            public void execute(GenerateEclipseJdtApt generateEclipseJdtApt) {
                generateEclipseJdtApt.setDescription("Generates the Eclipse JDT APT settings file.");
                generateEclipseJdtApt.setInputFile(project.file((Object)".settings/org.eclipse.jdt.apt.core.prefs"));
                generateEclipseJdtApt.setOutputFile(project.file((Object)".settings/org.eclipse.jdt.apt.core.prefs"));
                generateEclipseJdtApt.setJdtApt(jdtApt);
            }
        });
        AptPlugin.IMPL.configureTask(project, Task.class, "eclipse", AptEclipsePlugin.dependsOn(task));
        Object cleanTask = AptPlugin.IMPL.createTask(project, "cleanEclipseJdtApt", Delete.class, new Action<Delete>(){

            public void execute(Delete cleanEclipseJdtApt) {
                cleanEclipseJdtApt.delete(new Object[]{task});
            }
        });
        AptPlugin.IMPL.configureTask(project, Task.class, "cleanEclipse", AptEclipsePlugin.dependsOn(cleanTask));
    }

    private void configureFactorypath(final Project project, EclipseModel eclipseModel, SourceSet mainSourceSet, SourceSet testSourceSet) {
        final EclipseFactorypath factorypath = (EclipseFactorypath)this.instantiator.newInstance(EclipseFactorypath.class, new Object[]{new XmlFileContentMerger(new XmlTransformer())});
        ((ExtensionAware)eclipseModel).getExtensions().add("factorypath", (Object)factorypath);
        factorypath.setPlusConfigurations(new ArrayList<Configuration>(Arrays.asList(project.getConfigurations().getByName(AptPlugin.IMPL.getAnnotationProcessorConfigurationName(mainSourceSet)), project.getConfigurations().getByName(AptPlugin.IMPL.getAnnotationProcessorConfigurationName(testSourceSet)))));
        final Object task = AptPlugin.IMPL.createTask(project, "eclipseFactorypath", GenerateEclipseFactorypath.class, new Action<GenerateEclipseFactorypath>(){

            public void execute(GenerateEclipseFactorypath generateEclipseFactorypath) {
                generateEclipseFactorypath.setDescription("Generates the Eclipse factorypath file.");
                generateEclipseFactorypath.setInputFile(project.file((Object)".factorypath"));
                generateEclipseFactorypath.setOutputFile(project.file((Object)".factorypath"));
                generateEclipseFactorypath.setFactorypath(factorypath);
                generateEclipseFactorypath.dependsOn(factorypath.getPlusConfigurations().toArray());
            }
        });
        AptPlugin.IMPL.configureTask(project, Task.class, "eclipse", AptEclipsePlugin.dependsOn(task));
        Object cleanTask = AptPlugin.IMPL.createTask(project, "cleanEclipseFactorypath", Delete.class, new Action<Delete>(){

            public void execute(Delete cleanEclipseFactorypath) {
                cleanEclipseFactorypath.delete(new Object[]{task});
            }
        });
        AptPlugin.IMPL.configureTask(project, Task.class, "cleanEclipse", AptEclipsePlugin.dependsOn(cleanTask));
    }
}

