/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.util.timer;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.timer.Timer;
import org.tio.utils.timer.TimerTask;

public class AckTimerTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(AckTimerTask.class);
    private final Timer timer;
    private final Runnable command;
    private final int maxRetryCount;
    private int count = 1;

    public AckTimerTask(Timer timer, Runnable command, int maxRetryCount, int retryIntervalSecs) {
        super(TimeUnit.SECONDS.toMillis(retryIntervalSecs));
        this.timer = Objects.requireNonNull(timer, "Timer is null.");
        this.command = Objects.requireNonNull(command, "Runnable command is null.");
        this.maxRetryCount = maxRetryCount;
    }

    public void run() {
        if (++this.count <= this.maxRetryCount + 1) {
            this.timer.add((TimerTask)this);
            log.debug("Mqtt ack task retry running count\uff1a{}.", (Object)this.count);
            try {
                this.command.run();
            }
            catch (Exception e) {
                log.error("Mqtt ack task error ", (Throwable)e);
            }
        }
    }
}

