/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.common;

import java.util.Objects;
import net.dreamlu.iot.mqtt.codec.MqttMessage;
import net.dreamlu.iot.mqtt.codec.MqttPublishMessage;
import net.dreamlu.iot.mqtt.core.common.RetryProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.utils.timer.TimerTaskService;

public final class MqttPendingQos2Publish {
    private static final Logger logger = LoggerFactory.getLogger(MqttPendingQos2Publish.class);
    private final MqttPublishMessage incomingPublish;
    private final RetryProcessor<MqttMessage> retryProcessor = new RetryProcessor();

    public MqttPendingQos2Publish(MqttPublishMessage incomingPublish, MqttMessage originalMessage) {
        this.incomingPublish = incomingPublish;
        this.retryProcessor.setOriginalMessage(originalMessage);
    }

    public MqttPublishMessage getIncomingPublish() {
        return this.incomingPublish;
    }

    public void startPubRecRetransmitTimer(TimerTaskService taskService, ChannelContext context) {
        this.retryProcessor.setHandle((fixedHeader, originalMessage) -> {
            boolean result = Tio.send((ChannelContext)context, (Packet)new MqttMessage(fixedHeader, originalMessage.variableHeader()));
            if (context.isServer()) {
                logger.info("retry send PubRec msg clientId:{} result:{}", (Object)context.getBsId(), (Object)result);
            } else {
                logger.info("retry send PubRec msg result:{}", (Object)result);
            }
        });
        this.retryProcessor.start(taskService);
    }

    public void onPubRelReceived() {
        this.retryProcessor.stop();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttPendingQos2Publish that = (MqttPendingQos2Publish)o;
        return Objects.equals(this.incomingPublish, that.incomingPublish);
    }

    public int hashCode() {
        return Objects.hash(this.incomingPublish);
    }
}

