/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.internal.Throwables;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorContext;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;
import org.apache.kafka.streams.processor.api.ProcessingContext;

class TracingV2FixedKeyProcessor<KIn, VIn, VOut>
implements FixedKeyProcessor<KIn, VIn, VOut> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final Tracer tracer;
    final String spanName;
    final FixedKeyProcessor<KIn, VIn, VOut> delegateProcessor;
    FixedKeyProcessorContext processorContext;

    TracingV2FixedKeyProcessor(KafkaStreamsTracing kafkaStreamsTracing, String spanName, FixedKeyProcessor<KIn, VIn, VOut> delegateProcessor) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
        this.tracer = kafkaStreamsTracing.tracer;
        this.spanName = spanName;
        this.delegateProcessor = delegateProcessor;
    }

    public void init(FixedKeyProcessorContext<KIn, VOut> context) {
        this.processorContext = context;
        this.delegateProcessor.init(this.processorContext);
    }

    public void process(FixedKeyRecord<KIn, VIn> record) {
        Span span = this.kafkaStreamsTracing.nextSpan((ProcessingContext)this.processorContext, record.headers());
        if (!span.isNoop()) {
            span.name(this.spanName);
            span.start();
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        Throwable error = null;
        try {
            this.delegateProcessor.process(record);
        }
        catch (Throwable e) {
            error = e;
            Throwables.propagateIfFatal((Throwable)e);
            throw e;
        }
        finally {
            this.kafkaStreamsTracing.injector.inject(span.context(), (Object)record.headers());
            if (error != null) {
                span.error(error);
            }
            span.finish();
            ws.close();
        }
    }

    public void close() {
        this.delegateProcessor.close();
    }
}

