/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.impl.HeaderParser;
import io.vertx.ext.web.impl.ParsableHeaderValue;
import java.util.Map;
import java.util.regex.Pattern;

public class ParsableMIMEValue
extends ParsableHeaderValue
implements MIMEHeader {
    private String component = null;
    private String subComponent = null;
    private int orderWeight;
    private static final Pattern SPECIAL_CHARACTERS_IN_PARAM_VALUE = Pattern.compile(".*[\\s,;=\"].*");

    public ParsableMIMEValue(String headerContent) {
        super(headerContent);
    }

    @Override
    public String component() {
        this.ensureHeaderProcessed();
        return this.component;
    }

    @Override
    public String subComponent() {
        this.ensureHeaderProcessed();
        return this.subComponent;
    }

    @Override
    public String mediaType() {
        this.ensureHeaderProcessed();
        return this.component + "/" + this.subComponent;
    }

    @Override
    public String mediaTypeWithParams() {
        this.ensureHeaderProcessed();
        Map<String, String> parameters = this.parameters();
        if (parameters.isEmpty()) {
            return this.component + "/" + this.subComponent;
        }
        StringBuilder sb = new StringBuilder(this.component).append("/").append(this.subComponent);
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            sb.append("; ").append(ParsableMIMEValue.encodeParam(param));
        }
        return sb.toString();
    }

    @Override
    protected boolean isMatchedBy2(ParsableHeaderValue matchTry) {
        ParsableMIMEValue myMatchTry = (ParsableMIMEValue)matchTry;
        this.ensureHeaderProcessed();
        if (!("*".equals(this.component) || "*".equals(myMatchTry.component) || this.component.equals(myMatchTry.component))) {
            return false;
        }
        if (!("*".equals(this.subComponent) || "*".equals(myMatchTry.subComponent) || this.subComponent.equals(myMatchTry.subComponent))) {
            return false;
        }
        if ("*".equals(this.component) && "*".equals(this.subComponent) && this.parameters().size() == 0) {
            return true;
        }
        return super.isMatchedBy2(myMatchTry);
    }

    @Override
    protected void ensureHeaderProcessed() {
        super.ensureHeaderProcessed();
        if (this.component == null) {
            HeaderParser.parseMIME(this.value, this::setComponent, this::setSubComponent);
            this.orderWeight = "*".equals(this.component) ? 0 : 1;
            this.orderWeight += "*".equals(this.subComponent) ? 0 : 2;
        }
    }

    @Override
    public ParsableMIMEValue forceParse() {
        this.ensureHeaderProcessed();
        return this;
    }

    private void setComponent(String component) {
        this.component = "*".equals(component) ? "*" : component;
    }

    private void setSubComponent(String subComponent) {
        this.subComponent = "*".equals(subComponent) ? "*" : subComponent;
    }

    @Override
    protected int weightedOrderPart2() {
        return this.orderWeight;
    }

    private static String encodeParam(Map.Entry<String, String> param) {
        if (param.getValue() == null || param.getValue().isBlank()) {
            return param.getKey();
        }
        String value = param.getValue();
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return param.getKey() + "=" + value;
        }
        if (SPECIAL_CHARACTERS_IN_PARAM_VALUE.matcher(value).matches()) {
            value = value.replace("\"", "\\\"");
            return param.getKey() + "=\"" + value + "\"";
        }
        return param.getKey() + "=" + param.getValue();
    }
}

