/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Future;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.SecurityAudit;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.SimpleAuthenticationHandler;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.handler.impl.NOOPAuthenticationProvider;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.util.function.Function;

public class SimpleAuthenticationHandlerImpl
extends AuthenticationHandlerImpl<NOOPAuthenticationProvider>
implements SimpleAuthenticationHandler {
    private Function<RoutingContext, Future<User>> authn;

    public SimpleAuthenticationHandlerImpl() {
        super(new NOOPAuthenticationProvider());
    }

    @Override
    public Future<User> authenticate(RoutingContext ctx) {
        if (this.authn != null) {
            SecurityAudit audit = ((RoutingContextInternal)ctx).securityAudit();
            return this.authn.apply(ctx).andThen(op -> audit.audit(Marker.AUTHENTICATION, op.succeeded())).recover(err -> {
                if (err instanceof HttpException) {
                    return Future.failedFuture((Throwable)err);
                }
                return Future.failedFuture((Throwable)new HttpException(401, (Throwable)err));
            });
        }
        return Future.failedFuture((String)"No Authenticate function");
    }

    @Override
    public SimpleAuthenticationHandlerImpl authenticate(Function<RoutingContext, Future<User>> authnFunction) {
        this.authn = authnFunction;
        return this;
    }
}

