/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.rabbitmq.QueueOptionsConverter;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class QueueOptions {
    private static final int DEFAULT_QUEUE_SIZE = Integer.MAX_VALUE;
    private static final boolean DEFAULT_AUTO_ACK = true;
    private static final boolean DEFAULT_KEEP_MOST_RECENT = false;
    private static final boolean DEFAULT_NO_LOCAL = false;
    private static final boolean DEFAULT_CONSUMER_EXCLUSIVE = false;
    private static final String DEFAULT_CONSUMER_TAG = "";
    private boolean autoAck = true;
    private boolean keepMostRecent = false;
    private int maxInternalQueueSize = Integer.MAX_VALUE;
    private boolean noLocal = false;
    private boolean consumerExclusive = false;
    private String consumerTag = "";
    private Map<String, Object> consumerArguments = null;

    public QueueOptions() {
    }

    public QueueOptions(JsonObject json) {
        this();
        QueueOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public QueueOptions setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
        return this;
    }

    public QueueOptions setKeepMostRecent(boolean keepMostRecent) {
        this.keepMostRecent = keepMostRecent;
        return this;
    }

    public QueueOptions setMaxInternalQueueSize(int maxInternalQueueSize) {
        this.maxInternalQueueSize = maxInternalQueueSize;
        return this;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public int maxInternalQueueSize() {
        return this.maxInternalQueueSize;
    }

    public boolean isKeepMostRecent() {
        return this.keepMostRecent;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isConsumerExclusive() {
        return this.consumerExclusive;
    }

    public void setConsumerExclusive(boolean consumerExclusive) {
        this.consumerExclusive = consumerExclusive;
    }

    public String getConsumerTag() {
        return this.consumerTag;
    }

    public void setConsumerTag(String consumerTag) {
        this.consumerTag = consumerTag;
    }

    public Map<String, Object> getConsumerArguments() {
        return this.consumerArguments;
    }

    public void setConsumerArguments(Map<String, Object> consumerArguments) {
        this.consumerArguments = consumerArguments;
    }
}

