/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.impl.SysProps;
import io.vertx.core.internal.http.HttpHeadersInternal;
import java.nio.charset.StandardCharsets;

public class VertxHttpRequestDecoder
extends HttpRequestDecoder {
    private static final int HOST_AS_INT = 1953722112;
    private static final long CONNECTION_AS_LONG_0 = 7598807758576447232L;
    private static final short CONNECTION_AS_SHORT_1 = 28271;
    private static final long CONTENT_AS_LONG = 3275364211029339904L;
    private static final int TYPE_AS_INT = 1701869824;
    private static final long LENGTH_AS_LONG = 114849160783104L;
    private static final long ACCEPT_AS_LONG = 128026086171392L;
    private final AsciiString _Host;
    private final AsciiString _Connection;
    private final AsciiString _Content_Type;
    private final AsciiString _Content_Length;
    private final AsciiString _Accept;

    public VertxHttpRequestDecoder(HttpServerOptions options) {
        super(options.getMaxInitialLineLength(), options.getMaxHeaderSize(), options.getMaxChunkSize(), !HttpHeadersInternal.DISABLE_HTTP_HEADERS_VALIDATION, options.getDecoderInitialBufferSize());
        boolean internToLowerCase = SysProps.INTERN_COMMON_HTTP_REQUEST_HEADERS_TO_LOWER_CASE.getBoolean();
        this._Host = internToLowerCase ? HttpHeaderNames.HOST : this.intern("Host");
        this._Connection = internToLowerCase ? HttpHeaderNames.CONNECTION : this.intern("Connection");
        this._Content_Type = internToLowerCase ? HttpHeaderNames.CONTENT_TYPE : this.intern("Content-Type");
        this._Content_Length = internToLowerCase ? HttpHeaderNames.CONTENT_LENGTH : this.intern("Content-Length");
        this._Accept = internToLowerCase ? HttpHeaderNames.ACCEPT : this.intern("Accept");
    }

    private AsciiString intern(String name) {
        byte[] bytes = name.getBytes(StandardCharsets.UTF_8);
        return super.splitHeaderName(bytes, 0, bytes.length);
    }

    protected AsciiString splitHeaderName(byte[] sb, int start, int length) {
        byte firstChar = sb[start];
        if (firstChar == 72 || firstChar == 104) {
            if (length == 4 && VertxHttpRequestDecoder.isHost(sb, start)) {
                return firstChar == 72 ? this._Host : HttpHeaderNames.HOST;
            }
        } else if (firstChar == 65 || firstChar == 97) {
            if (length == 6 && VertxHttpRequestDecoder.isAccept(sb, start)) {
                return firstChar == 65 ? this._Accept : HttpHeaderNames.ACCEPT;
            }
        } else if (firstChar == 67 || firstChar == 99) {
            if (length == 10) {
                if (VertxHttpRequestDecoder.isConnection(sb, start)) {
                    return firstChar == 67 ? this._Connection : HttpHeaderNames.CONNECTION;
                }
            } else if (length == 12) {
                if (VertxHttpRequestDecoder.isContentType(sb, start)) {
                    return firstChar == 67 ? this._Content_Type : HttpHeaderNames.CONTENT_TYPE;
                }
            } else if (length == 14 && VertxHttpRequestDecoder.isContentLength(sb, start)) {
                return firstChar == 67 ? this._Content_Length : HttpHeaderNames.CONTENT_LENGTH;
            }
        }
        return new AsciiString(sb, start, length, true);
    }

    private static boolean isAccept(byte[] sb, int start) {
        long maybeAccept = (long)(sb[start + 1] << 8 | sb[start + 2] << 16 | sb[start + 3] << 24) | (long)sb[start + 4] << 32 | (long)sb[start + 5] << 40;
        return maybeAccept == 128026086171392L;
    }

    private static boolean isHost(byte[] sb, int start) {
        int maybeHost = sb[start + 1] << 8 | sb[start + 2] << 16 | sb[start + 3] << 24;
        int a = 1953722112;
        return maybeHost == 1953722112;
    }

    private static boolean isConnection(byte[] sb, int start) {
        long maybeConnecti = (long)(sb[start + 1] << 8 | sb[start + 2] << 16 | sb[start + 3] << 24) | (long)sb[start + 4] << 32 | (long)sb[start + 5] << 40 | (long)sb[start + 6] << 48 | (long)sb[start + 7] << 56;
        if (maybeConnecti != 7598807758576447232L) {
            return false;
        }
        short maybeOn = (short)(sb[start + 8] | sb[start + 9] << 8);
        return maybeOn == 28271;
    }

    private static boolean isContentType(byte[] sb, int start) {
        long maybeContent = (long)(sb[start + 1] << 8 | sb[start + 2] << 16 | sb[start + 3] << 24) | (long)sb[start + 4] << 32 | (long)sb[start + 5] << 40 | (long)sb[start + 6] << 48 | (long)sb[start + 7] << 56;
        if (maybeContent != 3275364211029339904L) {
            return false;
        }
        int maybeType = sb[start + 9] << 8 | sb[start + 10] << 16 | sb[start + 11] << 24;
        return maybeType == 1701869824;
    }

    private static boolean isContentLength(byte[] sb, int start) {
        long maybeContent = (long)(sb[start + 1] << 8 | sb[start + 2] << 16 | sb[start + 3] << 24) | (long)sb[start + 4] << 32 | (long)sb[start + 5] << 40 | (long)sb[start + 6] << 48 | (long)sb[start + 7] << 56;
        if (maybeContent != 3275364211029339904L) {
            return false;
        }
        long maybeLength = (long)(sb[start + 9] << 8 | sb[start + 10] << 16 | sb[start + 11] << 24) | (long)sb[start + 12] << 32 | (long)sb[start + 13] << 40;
        return maybeLength == 114849160783104L;
    }

    protected HttpMessage createMessage(String[] initialLine) {
        return new DefaultHttpRequest(HttpVersion.valueOf((String)initialLine[2]), HttpMethod.valueOf((String)initialLine[0]), initialLine[1], (HttpHeaders)HeadersMultiMap.httpHeaders());
    }

    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        if (msg == null) {
            return false;
        }
        if (msg.getClass() == DefaultHttpRequest.class) {
            return false;
        }
        return super.isContentAlwaysEmpty(msg);
    }
}

