/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.RFC3986;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.impl.HostAndPortImpl;
import io.vertx.core.spi.tracing.TagExtractor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.function.Consumer;

public final class HttpUtils {
    static final HttpClosedException CONNECTION_CLOSED_EXCEPTION = new HttpClosedException("Connection was closed");
    static final HttpClosedException STREAM_CLOSED_EXCEPTION = new HttpClosedException("Stream was closed");
    static final int SC_SWITCHING_PROTOCOLS = 101;
    static final int SC_BAD_GATEWAY = 502;
    static final TagExtractor<HttpServerRequest> SERVER_REQUEST_TAG_EXTRACTOR = new TagExtractor<HttpServerRequest>(){

        @Override
        public int len(HttpServerRequest req) {
            return req.query() == null ? 4 : 5;
        }

        @Override
        public String name(HttpServerRequest req, int index) {
            switch (index) {
                case 0: {
                    return "http.url";
                }
                case 1: {
                    return "http.request.method";
                }
                case 2: {
                    return "url.scheme";
                }
                case 3: {
                    return "url.path";
                }
                case 4: {
                    return "url.query";
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpServerRequest req, int index) {
            switch (index) {
                case 0: {
                    return req.absoluteURI();
                }
                case 1: {
                    return req.method().name();
                }
                case 2: {
                    return req.scheme();
                }
                case 3: {
                    return req.path();
                }
                case 4: {
                    return req.query();
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final TagExtractor<HttpServerResponse> SERVER_RESPONSE_TAG_EXTRACTOR = new TagExtractor<HttpServerResponse>(){

        @Override
        public int len(HttpServerResponse resp) {
            return 1;
        }

        @Override
        public String name(HttpServerResponse resp, int index) {
            if (index == 0) {
                return "http.response.status_code";
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpServerResponse resp, int index) {
            if (index == 0) {
                return Integer.toString(resp.getStatusCode());
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final TagExtractor<HttpRequestHead> CLIENT_HTTP_REQUEST_TAG_EXTRACTOR = new TagExtractor<HttpRequestHead>(){

        @Override
        public int len(HttpRequestHead req) {
            return 2;
        }

        @Override
        public String name(HttpRequestHead req, int index) {
            switch (index) {
                case 0: {
                    return "url.full";
                }
                case 1: {
                    return "http.request.method";
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpRequestHead req, int index) {
            switch (index) {
                case 0: {
                    return req.absoluteURI;
                }
                case 1: {
                    return req.method.name();
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final TagExtractor<HttpResponseHead> CLIENT_RESPONSE_TAG_EXTRACTOR = new TagExtractor<HttpResponseHead>(){

        @Override
        public int len(HttpResponseHead resp) {
            return 1;
        }

        @Override
        public String name(HttpResponseHead resp, int index) {
            if (index == 0) {
                return "http.response.status_code";
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpResponseHead resp, int index) {
            if (index == 0) {
                return Integer.toString(resp.statusCode);
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final StreamPriority DEFAULT_STREAM_PRIORITY = new StreamPriority(){

        @Override
        public StreamPriority setWeight(short weight) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }

        @Override
        public StreamPriority setDependency(int dependency) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }

        @Override
        public StreamPriority setExclusive(boolean exclusive) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }
    };
    private static final AsciiString TIMEOUT_EQ = AsciiString.of((CharSequence)"timeout=");
    private static final Consumer<CharSequence> HEADER_VALUE_VALIDATOR = HttpUtils::validateHeaderValue;
    private static final int HIGHEST_INVALID_VALUE_CHAR_MASK = -32;
    private static final int NO_CR_LF_STATE = 0;
    private static final int CR_STATE = 1;
    private static final int LF_STATE = 2;
    private static final boolean[] VALID_H_NAME_ASCII_CHARS = new boolean[128];
    private static final String[] SMALL_POSITIVE_LONGS;

    private HttpUtils() {
    }

    public static URI resolveURIReference(String base, String ref) throws URISyntaxException {
        return HttpUtils.resolveURIReference(URI.create(base), ref);
    }

    public static URI resolveURIReference(URI base, String ref) throws URISyntaxException {
        String query;
        String path;
        String authority;
        String scheme;
        URI _ref = URI.create(ref);
        if (_ref.getScheme() != null) {
            scheme = _ref.getScheme();
            authority = _ref.getAuthority();
            path = RFC3986.removeDotSegments(_ref.getRawPath());
            query = _ref.getRawQuery();
        } else {
            if (_ref.getAuthority() != null) {
                authority = _ref.getAuthority();
                path = _ref.getRawPath();
                query = _ref.getRawQuery();
            } else {
                if (_ref.getRawPath().isEmpty()) {
                    path = base.getRawPath();
                    query = _ref.getRawQuery() != null ? _ref.getRawQuery() : base.getRawQuery();
                } else {
                    if (_ref.getRawPath().startsWith("/")) {
                        path = RFC3986.removeDotSegments(_ref.getRawPath());
                    } else {
                        int index;
                        String basePath = base.getRawPath();
                        Object mergedPath = base.getAuthority() != null && basePath.isEmpty() ? "/" + _ref.getRawPath() : ((index = basePath.lastIndexOf(47)) > -1 ? basePath.substring(0, index + 1) + _ref.getRawPath() : _ref.getRawPath());
                        path = RFC3986.removeDotSegments((CharSequence)mergedPath);
                    }
                    query = _ref.getRawQuery();
                }
                authority = base.getAuthority();
            }
            scheme = base.getScheme();
        }
        return new URI(scheme, authority, path, query, _ref.getFragment());
    }

    static String parsePath(String uri) {
        int i;
        if (uri.isEmpty()) {
            return "";
        }
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
            if (i == 0) {
                return uri;
            }
        }
        return uri.substring(i, queryStart);
    }

    static String parseQuery(String uri) {
        int i = uri.indexOf(63);
        if (i == -1) {
            return null;
        }
        return uri.substring(i + 1);
    }

    static String absoluteURI(String serverOrigin, HttpServerRequest req) {
        Object absoluteURI;
        String uri = req.uri();
        if ("*".equals(uri)) {
            return null;
        }
        if (uri.startsWith("https://") || uri.startsWith("http://")) {
            return uri;
        }
        boolean ssl = req.isSSL();
        HostAndPort authority = req.authority();
        if (authority != null) {
            StringBuilder sb = new StringBuilder(req.scheme()).append("://").append(authority.host());
            if (authority.port() > 0 && ssl && authority.port() != 443 || !ssl && authority.port() != 80) {
                sb.append(':').append(authority.port());
            }
            sb.append(uri);
            absoluteURI = sb.toString();
        } else {
            absoluteURI = serverOrigin + uri;
        }
        return absoluteURI;
    }

    public static MultiMap params(String uri, Charset charset, boolean semicolonIsNormalChar) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri, charset, true, 1024, semicolonIsNormalChar);
        Map prms = queryStringDecoder.parameters();
        MultiMap params = MultiMap.caseInsensitiveMultiMap();
        if (!prms.isEmpty()) {
            for (Map.Entry entry : prms.entrySet()) {
                params.add((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return params;
    }

    public static void fromVertxInitialSettings(boolean server, Http2Settings vertxSettings, io.netty.handler.codec.http2.Http2Settings nettySettings) {
        if (vertxSettings != null) {
            Map<Integer, Long> extraSettings;
            if (!server && !vertxSettings.isPushEnabled()) {
                nettySettings.pushEnabled(vertxSettings.isPushEnabled());
            }
            if (vertxSettings.getHeaderTableSize() != 4096L) {
                nettySettings.put('\u0001', Long.valueOf(vertxSettings.getHeaderTableSize()));
            }
            if (vertxSettings.getInitialWindowSize() != 65535) {
                nettySettings.initialWindowSize(vertxSettings.getInitialWindowSize());
            }
            if (vertxSettings.getMaxConcurrentStreams() != 0xFFFFFFFFL) {
                nettySettings.maxConcurrentStreams(vertxSettings.getMaxConcurrentStreams());
            }
            if (vertxSettings.getMaxFrameSize() != 16384) {
                nettySettings.maxFrameSize(vertxSettings.getMaxFrameSize());
            }
            if (vertxSettings.getMaxHeaderListSize() != 8192L) {
                nettySettings.maxHeaderListSize(vertxSettings.getMaxHeaderListSize());
            }
            if ((extraSettings = vertxSettings.getExtraSettings()) != null) {
                extraSettings.forEach((code, setting) -> nettySettings.put((char)code.intValue(), setting));
            }
        }
    }

    public static io.netty.handler.codec.http2.Http2Settings fromVertxSettings(Http2Settings settings) {
        io.netty.handler.codec.http2.Http2Settings converted = new io.netty.handler.codec.http2.Http2Settings();
        converted.pushEnabled(settings.isPushEnabled());
        converted.maxFrameSize(settings.getMaxFrameSize());
        converted.initialWindowSize(settings.getInitialWindowSize());
        converted.headerTableSize(settings.getHeaderTableSize());
        converted.maxConcurrentStreams(settings.getMaxConcurrentStreams());
        converted.maxHeaderListSize(settings.getMaxHeaderListSize());
        if (settings.getExtraSettings() != null) {
            settings.getExtraSettings().forEach((key, value) -> converted.put((char)key.intValue(), value));
        }
        return converted;
    }

    public static Http2Settings toVertxSettings(io.netty.handler.codec.http2.Http2Settings settings) {
        Long headerTableSize;
        Integer initialWindowSize;
        Integer maxFrameSize;
        Long maxHeaderListSize;
        Long maxConcurrentStreams;
        Http2Settings converted = new Http2Settings();
        Boolean pushEnabled = settings.pushEnabled();
        if (pushEnabled != null) {
            converted.setPushEnabled(pushEnabled);
        }
        if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
            converted.setMaxConcurrentStreams(maxConcurrentStreams);
        }
        if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
            converted.setMaxHeaderListSize(maxHeaderListSize);
        }
        if ((maxFrameSize = settings.maxFrameSize()) != null) {
            converted.setMaxFrameSize(maxFrameSize);
        }
        if ((initialWindowSize = settings.initialWindowSize()) != null) {
            converted.setInitialWindowSize(initialWindowSize);
        }
        if ((headerTableSize = settings.headerTableSize()) != null) {
            converted.setHeaderTableSize(headerTableSize);
        }
        settings.forEach((key, value) -> {
            if (key.charValue() > '\u0006') {
                converted.set(key.charValue(), (long)value);
            }
        });
        return converted;
    }

    static io.netty.handler.codec.http2.Http2Settings decodeSettings(String base64Settings) {
        try {
            io.netty.handler.codec.http2.Http2Settings settings = new io.netty.handler.codec.http2.Http2Settings();
            Buffer buffer = Buffer.buffer(Base64.getUrlDecoder().decode(base64Settings));
            int len = buffer.length();
            for (int pos = 0; pos < len; pos += 4) {
                int i = buffer.getUnsignedShort(pos);
                long j = buffer.getUnsignedInt(pos += 2);
                settings.put((char)i, Long.valueOf(j));
            }
            return settings;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encodeSettings(Http2Settings settings) {
        Buffer buffer = Buffer.buffer();
        HttpUtils.fromVertxSettings(settings).forEach((c, l) -> {
            buffer.appendUnsignedShort(c.charValue());
            buffer.appendUnsignedInt((long)l);
        });
        return Base64.getUrlEncoder().encodeToString(buffer.getBytes());
    }

    public static ByteBuf generateWSCloseFrameByteBuf(short statusCode, String reason) {
        if (reason != null) {
            return Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.copyShort((int)statusCode), Unpooled.copiedBuffer((CharSequence)reason, (Charset)StandardCharsets.UTF_8)});
        }
        return Unpooled.copyShort((int)statusCode);
    }

    static void sendError(Channel ch, HttpResponseStatus status) {
        HttpUtils.sendError(ch, status, status.reasonPhrase());
    }

    static void sendError(Channel ch, HttpResponseStatus status, CharSequence err) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, status);
        if (status.code() == HttpResponseStatus.METHOD_NOT_ALLOWED.code()) {
            resp.headers().set(HttpHeaders.ALLOW, (Object)HttpHeaders.GET);
        }
        if (err != null) {
            resp.content().writeBytes(err.toString().getBytes(CharsetUtil.UTF_8));
            HttpUtil.setContentLength((HttpMessage)resp, (long)err.length());
        } else {
            HttpUtil.setContentLength((HttpMessage)resp, (long)0L);
        }
        ch.writeAndFlush((Object)resp);
    }

    static String getWebSocketLocation(HttpServerRequest req, boolean ssl) throws Exception {
        String prefix = ssl ? "wss://" : "ws://";
        URI uri = new URI(req.uri());
        String path = uri.getRawPath();
        String loc = prefix + req.headers().get((CharSequence)HttpHeaderNames.HOST) + path;
        String query = uri.getRawQuery();
        if (query != null) {
            loc = loc + "?" + query;
        }
        return loc;
    }

    public static CharSequence toLowerCase(CharSequence sequence) {
        StringBuilder buffer = null;
        int len = sequence.length();
        for (int index = 0; index < len; ++index) {
            char c = sequence.charAt(index);
            if (c < 'A' || c > 'Z') continue;
            if (buffer == null) {
                buffer = new StringBuilder(sequence);
            }
            buffer.setCharAt(index, (char)(c + 32));
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return sequence;
    }

    static io.netty.handler.codec.http.HttpVersion toNettyHttpVersion(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_0;
            }
            case HTTP_1_1: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_1;
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP version: " + String.valueOf((Object)version));
    }

    static HttpMethod toVertxMethod(String method) {
        return HttpMethod.valueOf(method);
    }

    public static int parseKeepAliveHeaderTimeout(CharSequence value) {
        int len = value.length();
        int pos = 0;
        while (pos < len) {
            int to;
            int next;
            int idx = AsciiString.indexOf((CharSequence)value, (char)',', (int)pos);
            if (idx == -1) {
                idx = next = len;
            } else {
                next = idx + 1;
            }
            while (pos < idx && value.charAt(pos) == ' ') {
                ++pos;
            }
            for (to = idx; to > pos && value.charAt(to - 1) == ' '; --to) {
            }
            if (AsciiString.regionMatches((CharSequence)value, (boolean)true, (int)pos, (CharSequence)TIMEOUT_EQ, (int)0, (int)TIMEOUT_EQ.length()) && (pos += TIMEOUT_EQ.length()) < to) {
                int ret = 0;
                while (pos < to) {
                    char ch;
                    if ((ch = value.charAt(pos++)) >= '0' && ch < '9') {
                        ret = ret * 10 + (ch - 48);
                        continue;
                    }
                    ret = -1;
                    break;
                }
                if (ret > -1) {
                    return ret;
                }
            }
            pos = next;
        }
        return -1;
    }

    public static void validateHeader(CharSequence name, CharSequence value) {
        HttpUtils.validateHeaderName(name);
        if (value != null) {
            HttpUtils.validateHeaderValue(value);
        }
    }

    public static void validateHeader(CharSequence name, Iterable<? extends CharSequence> values) {
        HttpUtils.validateHeaderName(name);
        values.forEach(value -> {
            if (value != null) {
                HEADER_VALUE_VALIDATOR.accept((CharSequence)value);
            }
        });
    }

    public static void validateHeaderValue(CharSequence value) {
        if (value instanceof AsciiString) {
            HttpUtils.validateAsciiHeaderValue((AsciiString)value);
        } else if (value instanceof String) {
            HttpUtils.validateStringHeaderValue((String)value);
        } else {
            HttpUtils.validateSequenceHeaderValue(value);
        }
    }

    private static void validateAsciiHeaderValue(AsciiString value) {
        int length = value.length();
        if (length == 0) {
            return;
        }
        byte[] asciiChars = value.array();
        int off = value.arrayOffset();
        if (off == 0 && length == asciiChars.length) {
            for (int index = 0; index < asciiChars.length; ++index) {
                int latinChar = asciiChars[index] & 0xFF;
                if (latinChar == 127) {
                    throw new IllegalArgumentException("a header value contains a prohibited character '127': " + String.valueOf(value));
                }
                if (latinChar >= 32 || latinChar == 9) continue;
                HttpUtils.validateSequenceHeaderValue((CharSequence)value, index - off);
                break;
            }
        } else {
            HttpUtils.validateAsciiRangeHeaderValue(value, off, length, asciiChars);
        }
    }

    private static void validateAsciiRangeHeaderValue(AsciiString value, int off, int length, byte[] asciiChars) {
        int end = off + length;
        for (int index = off; index < end; ++index) {
            int latinChar = asciiChars[index] & 0xFF;
            if (latinChar == 127) {
                throw new IllegalArgumentException("a header value contains a prohibited character '127': " + String.valueOf(value));
            }
            if (latinChar >= 32 || latinChar == 9) continue;
            HttpUtils.validateSequenceHeaderValue((CharSequence)value, index - off);
            break;
        }
    }

    private static void validateStringHeaderValue(String value) {
        int length = value.length();
        if (length == 0) {
            return;
        }
        for (int index = 0; index < length; ++index) {
            char latinChar = value.charAt(index);
            if (latinChar == '\u007f') {
                throw new IllegalArgumentException("a header value contains a prohibited character '127': " + value);
            }
            if (latinChar >= ' ' || latinChar == '\t') continue;
            HttpUtils.validateSequenceHeaderValue(value, index);
            break;
        }
    }

    private static void validateSequenceHeaderValue(CharSequence value) {
        int length = value.length();
        if (length == 0) {
            return;
        }
        for (int index = 0; index < length; ++index) {
            char latinChar = value.charAt(index);
            if (latinChar == '\u007f') {
                throw new IllegalArgumentException("a header value contains a prohibited character '127': " + String.valueOf(value));
            }
            if (latinChar >= ' ' || latinChar == '\t') continue;
            HttpUtils.validateSequenceHeaderValue(value, index);
            break;
        }
    }

    private static void validateSequenceHeaderValue(CharSequence seq, int index) {
        int state = HttpUtils.validateValueChar(seq, 0, seq.charAt(index));
        for (int i = index + 1; i < seq.length(); ++i) {
            state = HttpUtils.validateValueChar(seq, state, seq.charAt(i));
        }
        if (state != 0) {
            throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + String.valueOf(seq));
        }
    }

    private static int validateValueChar(CharSequence seq, int state, char ch) {
        if (ch == '\u007f') {
            throw new IllegalArgumentException("a header value contains a prohibited character '127': " + String.valueOf(seq));
        }
        if ((ch & 0xFFFFFFE0) == 0) {
            HttpUtils.validateNonPrintableCtrlChar(seq, ch);
            if (state == 0) {
                switch (ch) {
                    case '\r': {
                        return 1;
                    }
                    case '\n': {
                        return 2;
                    }
                }
                return 0;
            }
        }
        if (state != 0) {
            return HttpUtils.validateCrLfChar(seq, state, ch);
        }
        return 0;
    }

    private static int validateCrLfChar(CharSequence seq, int state, char ch) {
        switch (state) {
            case 1: {
                if (ch == '\n') {
                    return 2;
                }
                throw new IllegalArgumentException("only '\\n' is allowed after '\\r': " + String.valueOf(seq));
            }
            case 2: {
                switch (ch) {
                    case '\t': 
                    case ' ': {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("only ' ' and '\\t' are allowed after '\\n': " + String.valueOf(seq));
            }
        }
        throw new AssertionError();
    }

    private static void validateNonPrintableCtrlChar(CharSequence seq, int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            default: {
                throw new IllegalArgumentException("a header value contains a prohibited character '" + ch + "': " + String.valueOf(seq));
            }
        }
    }

    public static void validateHeaderName(CharSequence value) {
        if (value instanceof AsciiString) {
            HttpUtils.validateAsciiHeaderName((AsciiString)value);
        } else if (value instanceof String) {
            HttpUtils.validateStringHeaderName((String)value);
        } else {
            HttpUtils.validateSequenceHeaderName(value);
        }
    }

    private static void validateAsciiHeaderName(AsciiString value) {
        int len = value.length();
        int off = value.arrayOffset();
        byte[] asciiChars = value.array();
        for (int i = 0; i < len; ++i) {
            byte c = asciiChars[off + i];
            if (c < 0) {
                throw new IllegalArgumentException("a header name cannot contain non-ASCII character: " + String.valueOf(value));
            }
            if (VALID_H_NAME_ASCII_CHARS[c & 0x7F]) continue;
            throw new IllegalArgumentException("a header name cannot contain some prohibited characters, such as : " + String.valueOf(value));
        }
    }

    private static void validateStringHeaderName(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("a header name cannot contain non-ASCII character: " + value);
            }
            if (VALID_H_NAME_ASCII_CHARS[c & 0x7F]) continue;
            throw new IllegalArgumentException("a header name cannot contain some prohibited characters, such as : " + value);
        }
    }

    private static void validateSequenceHeaderName(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("a header name cannot contain non-ASCII character: " + String.valueOf(value));
            }
            if (VALID_H_NAME_ASCII_CHARS[c & 0x7F]) continue;
            throw new IllegalArgumentException("a header name cannot contain some prohibited characters, such as : " + String.valueOf(value));
        }
    }

    public static boolean isValidMultipartContentType(String contentType) {
        return HttpHeaderValues.MULTIPART_FORM_DATA.regionMatches(true, 0, (CharSequence)contentType, 0, HttpHeaderValues.MULTIPART_FORM_DATA.length()) || HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.regionMatches(true, 0, (CharSequence)contentType, 0, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.length());
    }

    public static boolean isValidMultipartMethod(io.netty.handler.codec.http.HttpMethod method) {
        return method.equals((Object)io.netty.handler.codec.http.HttpMethod.POST) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.PUT) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.PATCH) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.DELETE);
    }

    static Future<AsyncFile> resolveFile(ContextInternal context, String filename, long offset, long length) {
        Future<AsyncFile> future;
        VertxInternal vertx = context.owner();
        File file_ = vertx.fileResolver().resolve(filename);
        if (!file_.exists()) {
            return context.failedFuture(new FileNotFoundException());
        }
        RandomAccessFile raf = new RandomAccessFile(file_, "r");
        try {
            FileSystem fs = vertx.fileSystem();
            future = fs.open(filename, new OpenOptions().setCreate(false).setWrite(false)).transform(ar -> {
                if (ar.succeeded()) {
                    AsyncFile file = (AsyncFile)ar.result();
                    long contentLength = Math.min(length, file_.length() - offset);
                    if (contentLength < 0L) {
                        file.close();
                        return context.failedFuture("offset : " + offset + " is larger than the requested file length : " + file_.length());
                    }
                    file.setReadPos(offset);
                    file.setReadLength(contentLength);
                }
                return (Future)ar;
            });
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return context.failedFuture(e);
            }
        }
        raf.close();
        return future;
    }

    static boolean isConnectOrUpgrade(HttpMethod method, MultiMap headers) {
        if (method == HttpMethod.CONNECT) {
            return true;
        }
        if (method == HttpMethod.GET) {
            for (String connection : headers.getAll(HttpHeaders.CONNECTION)) {
                if (!AsciiString.containsIgnoreCase((CharSequence)connection, (CharSequence)HttpHeaders.UPGRADE)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isKeepAlive(HttpRequest request) {
        io.netty.handler.codec.http.HttpVersion version = request.protocolVersion();
        return version == io.netty.handler.codec.http.HttpVersion.HTTP_1_1 && !request.headers().contains(HttpHeaders.CONNECTION, HttpHeaders.CLOSE, true) || version == io.netty.handler.codec.http.HttpVersion.HTTP_1_0 && request.headers().contains(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE, true);
    }

    public static boolean isValidHostAuthority(String host) {
        int len = host.length();
        return HostAndPortImpl.parseHost(host, 0, len) == len;
    }

    public static boolean canUpgradeToWebSocket(HttpServerRequest req) {
        if (req.version() != HttpVersion.HTTP_1_1) {
            return false;
        }
        if (req.method() != HttpMethod.GET) {
            return false;
        }
        MultiMap headers = req.headers();
        for (String connection : headers.getAll(HttpHeaders.CONNECTION)) {
            if (!AsciiString.containsIgnoreCase((CharSequence)connection, (CharSequence)HttpHeaders.UPGRADE)) continue;
            for (String upgrade : headers.getAll(HttpHeaders.UPGRADE)) {
                if (!AsciiString.containsIgnoreCase((CharSequence)upgrade, (CharSequence)HttpHeaders.WEBSOCKET)) continue;
                return true;
            }
        }
        return false;
    }

    public static HostAndPort socketAddressToHostAndPort(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return new HostAndPortImpl(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        }
        return null;
    }

    public static String positiveLongToString(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("contentLength must be >= 0");
        }
        if (value >= (long)SMALL_POSITIVE_LONGS.length) {
            return Long.toString(value);
        }
        int index = (int)value;
        String str = SMALL_POSITIVE_LONGS[index];
        if (str == null) {
            HttpUtils.SMALL_POSITIVE_LONGS[index] = str = Long.toString(value);
        }
        return str;
    }

    static {
        Arrays.fill(VALID_H_NAME_ASCII_CHARS, true);
        HttpUtils.VALID_H_NAME_ASCII_CHARS[32] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[34] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[40] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[41] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[44] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[47] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[58] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[59] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[60] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[62] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[61] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[63] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[64] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[91] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[93] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[92] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[123] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[125] = false;
        HttpUtils.VALID_H_NAME_ASCII_CHARS[127] = false;
        for (int i = 0; i < 32; ++i) {
            HttpUtils.VALID_H_NAME_ASCII_CHARS[i] = false;
        }
        SMALL_POSITIVE_LONGS = new String[256];
    }
}

