/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker00;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker07;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker08;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker13;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.http.WebSocketVersion;
import io.vertx.core.http.impl.Http1xConnection;
import io.vertx.core.http.impl.HttpClientBase;
import io.vertx.core.http.impl.HttpClientConnectionInternal;
import io.vertx.core.http.impl.HttpClientPush;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxAssembledHttpRequest;
import io.vertx.core.http.impl.VertxFullHttpRequest;
import io.vertx.core.http.impl.WebSocketConnectionImpl;
import io.vertx.core.http.impl.WebSocketHandshakeInboundHandler;
import io.vertx.core.http.impl.WebSocketImpl;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.internal.concurrent.InboundMessageQueue;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.MessageWrite;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.streams.WriteStream;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class Http1xClientConnection
extends Http1xConnection
implements HttpClientConnectionInternal {
    private static final Handler<Object> INVALID_MSG_HANDLER = ReferenceCountUtil::release;
    private final HttpClientBase client;
    private final HttpClientOptions options;
    private final boolean ssl;
    private final SocketAddress server;
    private final HostAndPort authority;
    public final ClientMetrics metrics;
    private final HttpVersion version;
    private final boolean pooled;
    private final long lifetimeEvictionTimestamp;
    private final Deque<Stream> requests = new ArrayDeque<Stream>();
    private final Deque<Stream> responses = new ArrayDeque<Stream>();
    private boolean closed;
    private boolean evicted;
    private Handler<Void> evictionHandler = DEFAULT_EVICTION_HANDLER;
    private Handler<Object> invalidMessageHandler = INVALID_MSG_HANDLER;
    private boolean wantClose;
    private boolean isConnect;
    private int keepAliveTimeout;
    private long expirationTimestamp;
    private int seq = 1;
    private Deque<WebSocketFrame> pendingFrames;
    private long lastResponseReceivedTimestamp;

    Http1xClientConnection(HttpVersion version, HttpClientBase client, ChannelHandlerContext chctx, boolean ssl, SocketAddress server, HostAndPort authority, ContextInternal context, ClientMetrics metrics, boolean pooled, long maxLifetime) {
        super(context, chctx);
        this.client = client;
        this.options = client.options();
        this.ssl = ssl;
        this.server = server;
        this.authority = authority;
        this.metrics = metrics;
        this.version = version;
        this.lifetimeEvictionTimestamp = maxLifetime > 0L ? System.currentTimeMillis() + maxLifetime : Long.MAX_VALUE;
        this.keepAliveTimeout = this.options.getKeepAliveTimeout();
        this.expirationTimestamp = Http1xClientConnection.expirationTimestampOf(this.keepAliveTimeout);
        this.pooled = pooled;
    }

    @Override
    public HostAndPort authority() {
        return this.authority;
    }

    @Override
    public HttpClientConnectionInternal evictionHandler(Handler<Void> handler) {
        this.evictionHandler = handler;
        return this;
    }

    @Override
    public HttpClientConnectionInternal invalidMessageHandler(Handler<Object> handler) {
        this.invalidMessageHandler = handler;
        return this;
    }

    @Override
    public HttpClientConnectionInternal concurrencyChangeHandler(Handler<Long> handler) {
        return this;
    }

    @Override
    public long concurrency() {
        return this.options.isPipelining() ? (long)this.options.getPipeliningLimit() : 1L;
    }

    @Override
    public synchronized long activeStreams() {
        return this.requests.isEmpty() && this.responses.isEmpty() ? 0L : 1L;
    }

    @Override
    public boolean pooled() {
        return this.pooled;
    }

    public NetSocketInternal toNetSocket() {
        this.evictionHandler.handle(null);
        this.chctx.pipeline().replace("handler", "handler", VertxHandler.create(ctx -> {
            NetSocketImpl socket = new NetSocketImpl(this.context, (ChannelHandlerContext)ctx, null, null, this.metrics(), false);
            socket.metric(this.metric());
            return socket;
        }));
        VertxHandler handler = (VertxHandler)this.chctx.pipeline().get(VertxHandler.class);
        return (NetSocketInternal)handler.getConnection();
    }

    private HttpRequest createRequest(HttpMethod method, String uri, MultiMap headerMap, String authority, boolean chunked, ByteBuf buf, boolean end) {
        Object request = new DefaultHttpRequest(HttpUtils.toNettyHttpVersion(this.version), method.toNetty(), uri, false);
        io.netty.handler.codec.http.HttpHeaders headers = request.headers();
        if (headerMap != null) {
            for (Map.Entry header : headerMap) {
                headers.add((String)header.getKey(), header.getValue());
            }
        }
        if (!headers.contains(HttpHeaders.HOST)) {
            if (authority != null) {
                request.headers().set(HttpHeaders.HOST, (Object)authority);
            }
        } else {
            headers.remove(HttpHeaders.TRANSFER_ENCODING);
        }
        if (chunked) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)request, (boolean)true);
        }
        if (this.options.isDecompressionSupported() && request.headers().get(HttpHeaders.ACCEPT_ENCODING) == null) {
            CharSequence acceptEncoding = Http1xClientConnection.determineCompressionAcceptEncoding();
            request.headers().set(HttpHeaders.ACCEPT_ENCODING, (Object)acceptEncoding);
        }
        if (!this.options.isKeepAlive() && this.options.getProtocolVersion() == HttpVersion.HTTP_1_1) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.CLOSE);
        } else if (this.options.isKeepAlive() && this.options.getProtocolVersion() == HttpVersion.HTTP_1_0) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
        }
        if (end) {
            request = buf != null ? new VertxFullHttpRequest((HttpRequest)request, buf) : new VertxFullHttpRequest((HttpRequest)request);
        } else if (buf != null) {
            request = new VertxAssembledHttpRequest((HttpRequest)request, buf);
        }
        return request;
    }

    static CharSequence determineCompressionAcceptEncoding() {
        if (Http1xClientConnection.isBrotliAvailable() && Http1xClientConnection.isZstdAvailable()) {
            return HttpHeaders.DEFLATE_GZIP_ZSTD_BR_SNAPPY;
        }
        if (!Http1xClientConnection.isBrotliAvailable() && Http1xClientConnection.isZstdAvailable()) {
            return HttpHeaders.DEFLATE_GZIP_ZSTD;
        }
        if (Http1xClientConnection.isBrotliAvailable() && !Http1xClientConnection.isZstdAvailable()) {
            return HttpHeaders.DEFLATE_GZIP_BR;
        }
        return HttpHeaders.DEFLATE_GZIP;
    }

    private static boolean isBrotliAvailable() {
        return Brotli.isAvailable();
    }

    private static boolean isZstdAvailable() {
        return Zstd.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginRequest(Stream stream, HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, boolean connect, Promise<Void> promise) {
        request.id = stream.id;
        request.remoteAddress = this.remoteAddress();
        stream.bytesWritten = stream.bytesWritten + (buf != null ? (long)buf.readableBytes() : 0L);
        HttpRequest nettyRequest = this.createRequest(request.method, request.uri, request.headers, request.authority, chunked, buf, end);
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            VertxTracer tracer;
            this.responses.add(stream);
            this.isConnect = connect;
            if (this.metrics != null) {
                stream.metric = this.metrics.requestBegin(request.uri, request);
            }
            if ((tracer = stream.context.tracer()) != null) {
                BiConsumer<String, String> headers = (key, val) -> new HeadersAdaptor(nettyRequest.headers()).add((String)key, (String)val);
                String operation = request.traceOperation;
                if (operation == null) {
                    operation = request.method.name();
                }
                stream.trace = tracer.sendRequest(stream.context, SpanKind.RPC, this.options.getTracingPolicy(), request, operation, headers, HttpUtils.CLIENT_HTTP_REQUEST_TAG_EXTRACTOR);
            }
        }
        this.write((Object)nettyRequest, false, promise);
        if (end) {
            this.endRequest(stream);
        }
    }

    private void writeBufferToChannel(Stream s, ByteBuf buff, boolean end, Promise<Void> listener) {
        s.bytesWritten = s.bytesWritten + (buff != null ? (long)buff.readableBytes() : 0L);
        if (this.isConnect) {
            ByteBuf msg;
            ByteBuf byteBuf = msg = buff != null ? buff : Unpooled.EMPTY_BUFFER;
            if (end) {
                this.write((Object)msg, false, listener).addListener(v -> this.closeInternal());
            } else {
                this.write(msg, false);
            }
        } else {
            Object msg = end ? (buff != null && buff.isReadable() ? new DefaultLastHttpContent(buff, false) : LastHttpContent.EMPTY_LAST_CONTENT) : new DefaultHttpContent(buff);
            this.write(msg, false, listener);
            if (end) {
                this.endRequest(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRequest(Stream s) {
        boolean responseEnded;
        Stream next;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            s.requestEnded = true;
            this.requests.pop();
            next = this.requests.peek();
            responseEnded = s.responseEnded;
            if (this.metrics != null) {
                this.metrics.requestEnd(s.metric, s.bytesWritten);
            }
        }
        this.flushBytesWritten();
        if (next != null) {
            next.promise.complete((HttpClientStream)((Object)next));
        }
        if (responseEnded) {
            s.context.execute(null, s::handleClosed);
            this.checkLifecycle();
        }
    }

    private Boolean reset(Stream stream) {
        if (stream.reset) {
            return null;
        }
        stream.reset = true;
        if (!this.responses.contains(stream)) {
            this.requests.remove(stream);
            return true;
        }
        this.close();
        return false;
    }

    private void writeHead(final Stream stream, final HttpRequestHead request, final boolean chunked, final ByteBuf buf, final boolean end, final boolean connect, final Promise<Void> listener) {
        this.writeToChannel(new MessageWrite(){

            @Override
            public void write() {
                if (stream.reset) {
                    listener.fail("Stream reset");
                    return;
                }
                stream.request = request;
                Http1xClientConnection.this.beginRequest(stream, request, chunked, buf, end, connect, listener);
            }

            @Override
            public void cancel(Throwable cause) {
                listener.fail(cause);
            }
        });
    }

    private void writeBuffer(final Stream stream, final ByteBuf buff, final boolean end, final Promise<Void> listener) {
        this.writeToChannel(new MessageWrite(){

            @Override
            public void write() {
                if (stream.reset) {
                    listener.fail("Stream reset");
                    return;
                }
                Http1xClientConnection.this.writeBufferToChannel(stream, buff, end, listener);
            }

            @Override
            public void cancel(Throwable cause) {
                listener.fail(cause);
            }
        });
    }

    @Override
    protected void handleShutdown(Object reason, long timeout, TimeUnit unit, ChannelPromise promise) {
        super.handleShutdown(reason, timeout, unit, promise);
        this.checkLifecycle();
    }

    private boolean checkLifecycle() {
        if (this.wantClose || this.shutdownInitiated && this.requests.isEmpty() && this.responses.isEmpty()) {
            this.closeInternal();
            return true;
        }
        if (!this.isConnect) {
            this.expirationTimestamp = Http1xClientConnection.expirationTimestampOf(this.keepAliveTimeout);
        }
        return false;
    }

    @Override
    protected void handleClose(Object reason, ChannelPromise promise) {
        if (!this.evicted) {
            this.evicted = true;
            if (this.evictionHandler != null) {
                this.evictionHandler.handle(null);
            }
        }
        super.handleClose(reason, promise);
    }

    private Throwable validateMessage(Object msg) {
        if (msg instanceof HttpObject) {
            io.netty.handler.codec.http.HttpVersion version;
            HttpObject obj = (HttpObject)msg;
            DecoderResult result = obj.decoderResult();
            if (result.isFailure()) {
                return result.cause();
            }
            if (obj instanceof HttpResponse && (version = ((HttpResponse)obj).protocolVersion()) != io.netty.handler.codec.http.HttpVersion.HTTP_1_0 && version != io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                return new IllegalStateException("Unsupported HTTP version: " + String.valueOf(version));
            }
        }
        return null;
    }

    @Override
    public void handleMessage(Object msg) {
        Throwable error = this.validateMessage(msg);
        if (error != null) {
            ReferenceCountUtil.release((Object)msg);
            this.fail(error);
        } else if (msg instanceof HttpObject) {
            this.handleHttpMessage((HttpObject)msg);
        } else if (msg instanceof ByteBuf && this.isConnect) {
            this.handleChunk((ByteBuf)msg);
        } else if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (this.pendingFrames == null) {
                this.pendingFrames = new ArrayDeque<WebSocketFrame>();
            }
            this.pendingFrames.add(frame);
        } else {
            this.invalidMessageHandler.handle(msg);
            this.fail(new VertxException("Received an invalid message: " + msg.getClass().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttpMessage(HttpObject obj) {
        Stream stream;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            stream = this.responses.peekFirst();
        }
        if (stream == null) {
            this.invalidMessageHandler.handle(obj);
            this.fail(new VertxException("Received an HTTP message with no request in progress: " + obj.getClass().getName()));
        } else if (obj instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)obj;
            HttpVersion version = response.protocolVersion() == io.netty.handler.codec.http.HttpVersion.HTTP_1_0 ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
            this.handleResponseBegin(stream, new HttpResponseHead(version, response.status().code(), response.status().reasonPhrase(), new HeadersAdaptor(response.headers())));
        } else if (obj instanceof HttpContent) {
            HttpContent chunk = (HttpContent)obj;
            if (chunk.content().isReadable()) {
                this.handleResponseChunk(stream, chunk.content());
            }
            if (!this.isConnect && chunk instanceof LastHttpContent) {
                this.handleResponseEnd(stream, (LastHttpContent)chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChunk(ByteBuf chunk) {
        Stream stream;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            stream = this.responses.peekFirst();
            if (stream == null) {
                return;
            }
        }
        if (chunk.isReadable()) {
            this.handleResponseChunk(stream, chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseBegin(Stream stream, HttpResponseHead response) {
        if (response.statusCode == HttpResponseStatus.CONTINUE.code()) {
            stream.handleContinue();
        } else if (response.statusCode == HttpResponseStatus.EARLY_HINTS.code()) {
            stream.handleEarlyHints(response.headers);
        } else {
            HttpRequestHead request;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                request = stream.request;
                stream.response = response;
                if (this.metrics != null) {
                    this.metrics.responseBegin(stream.metric, response);
                }
            }
            stream.handleHead(response);
            if (this.isConnect) {
                if (request.method == HttpMethod.CONNECT && response.statusCode == 200 || request.method == HttpMethod.GET && request.headers != null && request.headers.contains(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE, true) && response.statusCode == 101) {
                    this.removeChannelHandlers();
                } else {
                    this.isConnect = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannelHandlers() {
        ChannelPipeline pipeline = this.chctx.pipeline();
        ChannelHandler inflater = pipeline.get(HttpContentDecompressor.class);
        if (inflater != null) {
            pipeline.remove(inflater);
        }
        Handler<Object> prev = this.invalidMessageHandler;
        this.invalidMessageHandler = INVALID_MSG_HANDLER;
        try {
            pipeline.remove("codec");
        }
        finally {
            this.invalidMessageHandler = prev;
        }
    }

    private void handleResponseChunk(Stream stream, ByteBuf chunk) {
        BufferInternal buff = BufferInternal.safeBuffer(chunk);
        int len = buff.length();
        stream.bytesRead += (long)len;
        if (!stream.reset) {
            stream.handleChunk(buff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseEnd(Stream stream, LastHttpContent trailer) {
        boolean check;
        HttpResponseHead response;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            response = stream.response;
            if (response == null) {
                return;
            }
            this.responses.pop();
            HttpRequestHead request = stream.request;
            if (request.method != HttpMethod.CONNECT && response.statusCode != 101) {
                int timeout;
                boolean close;
                String responseConnectionHeader = response.headers.get((CharSequence)HttpHeaderNames.CONNECTION);
                String requestConnectionHeader = request.headers != null ? request.headers.get((CharSequence)HttpHeaderNames.CONNECTION) : null;
                boolean bl = close = !this.options.isKeepAlive();
                if (HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)responseConnectionHeader) || HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)requestConnectionHeader)) {
                    close = true;
                } else if (response.version == HttpVersion.HTTP_1_0 && !HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase((CharSequence)responseConnectionHeader)) {
                    close = true;
                }
                this.wantClose = close;
                String keepAliveHeader = response.headers.get((CharSequence)HttpHeaderNames.KEEP_ALIVE);
                if (keepAliveHeader != null && (timeout = HttpUtils.parseKeepAliveHeaderTimeout(keepAliveHeader)) != -1) {
                    this.keepAliveTimeout = timeout;
                }
            }
            stream.responseEnded = true;
            check = this.requests.peek() != stream;
        }
        VertxTracer tracer = stream.context.tracer();
        if (tracer != null) {
            tracer.receiveResponse(stream.context, response, stream.trace, null, HttpUtils.CLIENT_RESPONSE_TAG_EXTRACTOR);
        }
        if (this.metrics != null) {
            this.metrics.responseEnd(stream.metric, stream.bytesRead);
        }
        this.flushBytesRead();
        if (check) {
            this.checkLifecycle();
        }
        this.lastResponseReceivedTimestamp = System.currentTimeMillis();
        if (!stream.reset) {
            stream.handleEnd(trailer);
        }
        if (stream.requestEnded) {
            stream.handleClosed(null);
        }
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.client.metrics();
    }

    synchronized void toWebSocket(ContextInternal context, String requestURI, MultiMap headers, boolean allowOriginHeader, WebSocketClientOptions options, WebSocketVersion vers, List<String> subProtocols, long handshakeTimeout, boolean registerWriteHandlers, int maxWebSocketFrameSize, Promise<WebSocket> promise) {
        try {
            DefaultHttpHeaders nettyHeaders;
            URI wsuri = new URI(requestURI);
            if (!wsuri.isAbsolute()) {
                wsuri = new URI((this.ssl ? "https:" : "http:") + "//" + this.server.host() + ":" + this.server.port() + requestURI);
            }
            io.netty.handler.codec.http.websocketx.WebSocketVersion version = io.netty.handler.codec.http.websocketx.WebSocketVersion.valueOf((String)((Enum)(vers == null ? io.netty.handler.codec.http.websocketx.WebSocketVersion.V13 : vers)).toString());
            if (headers != null) {
                nettyHeaders = new DefaultHttpHeaders();
                for (Map.Entry entry : headers) {
                    nettyHeaders.add((String)entry.getKey(), entry.getValue());
                }
            } else {
                nettyHeaders = null;
            }
            long timer = handshakeTimeout > 0L ? this.vertx.setTimer(handshakeTimeout, id -> this.closeInternal()) : -1L;
            ChannelPipeline p = this.chctx.channel().pipeline();
            ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = this.initializeWebSocketExtensionHandshakers(options);
            if (!extensionHandshakers.isEmpty()) {
                p.addBefore("handler", "webSocketsExtensionsHandler", (ChannelHandler)new WebSocketClientExtensionHandler(extensionHandshakers.toArray(new WebSocketClientExtensionHandshaker[0])));
            }
            String subp = null;
            if (subProtocols != null) {
                subp = String.join((CharSequence)",", subProtocols);
            }
            WebSocketClientHandshaker handshaker = Http1xClientConnection.newHandshaker(wsuri, version, subp, !extensionHandshakers.isEmpty(), allowOriginHeader, (io.netty.handler.codec.http.HttpHeaders)nettyHeaders, maxWebSocketFrameSize, !options.isSendUnmaskedFrames());
            io.netty.util.concurrent.Promise upgrade = this.chctx.executor().newPromise();
            WebSocketHandshakeInboundHandler handshakeInboundHandler = new WebSocketHandshakeInboundHandler(handshaker, (io.netty.util.concurrent.Promise<io.netty.handler.codec.http.HttpHeaders>)upgrade);
            p.addBefore("handler", "handshakeCompleter", (ChannelHandler)handshakeInboundHandler);
            upgrade.addListener(future -> {
                if (timer > -1L) {
                    this.vertx.cancelTimer(timer);
                }
                if (future.isSuccess()) {
                    VertxHandler<WebSocketConnectionImpl> handler = VertxHandler.create(ctx -> {
                        WebSocketConnectionImpl conn = new WebSocketConnectionImpl(context, (ChannelHandlerContext)ctx, false, TimeUnit.SECONDS.toMillis(options.getClosingTimeout()), this.client.metrics());
                        WebSocketImpl webSocket = new WebSocketImpl(context, conn, version != io.netty.handler.codec.http.websocketx.WebSocketVersion.V00, options.getMaxFrameSize(), options.getMaxMessageSize(), registerWriteHandlers);
                        conn.webSocket(webSocket);
                        conn.metric(this.metric());
                        return conn;
                    });
                    ChannelPipeline pipeline = this.chctx.pipeline();
                    pipeline.replace(VertxHandler.class, "handler", handler);
                    WebSocketImpl ws = (WebSocketImpl)handler.getConnection().webSocket();
                    ws.headers(new HeadersAdaptor((io.netty.handler.codec.http.HttpHeaders)future.getNow()));
                    ws.subProtocol(handshaker.actualSubprotocol());
                    ws.registerHandler(this.vertx.eventBus());
                    HttpClientMetrics metrics = this.client.metrics();
                    if (metrics != null) {
                        ws.setMetric(metrics.connected(ws));
                    }
                    ws.pause();
                    Deque<WebSocketFrame> toResubmit = this.pendingFrames;
                    if (toResubmit != null) {
                        WebSocketFrame frame;
                        this.pendingFrames = null;
                        while ((frame = toResubmit.poll()) != null) {
                            handler.getConnection().handleWsFrame(frame);
                        }
                    }
                    promise.complete(ws);
                } else {
                    this.closeInternal();
                    promise.fail(future.cause());
                }
            });
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    static WebSocketClientHandshaker newHandshaker(URI webSocketURL, io.netty.handler.codec.http.websocketx.WebSocketVersion version, String subprotocol, boolean allowExtensions, final boolean allowOriginHeader, io.netty.handler.codec.http.HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking) {
        final WebSocketDecoderConfig config = WebSocketDecoderConfig.newBuilder().expectMaskedFrames(false).allowExtensions(allowExtensions).maxFramePayloadLength(maxFramePayloadLength).allowMaskMismatch(false).closeOnProtocolViolation(false).build();
        if (version == io.netty.handler.codec.http.websocketx.WebSocketVersion.V13) {
            return new WebSocketClientHandshaker13(webSocketURL, io.netty.handler.codec.http.websocketx.WebSocketVersion.V13, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket13FrameDecoder(config);
                }

                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove(HttpHeaders.ORIGIN);
                    }
                    return request;
                }
            };
        }
        if (version == io.netty.handler.codec.http.websocketx.WebSocketVersion.V08) {
            return new WebSocketClientHandshaker08(webSocketURL, io.netty.handler.codec.http.websocketx.WebSocketVersion.V08, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket08FrameDecoder(config);
                }

                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN);
                    }
                    return request;
                }
            };
        }
        if (version == io.netty.handler.codec.http.websocketx.WebSocketVersion.V07) {
            return new WebSocketClientHandshaker07(webSocketURL, io.netty.handler.codec.http.websocketx.WebSocketVersion.V07, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket07FrameDecoder(config);
                }

                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN);
                    }
                    return request;
                }
            };
        }
        if (version == io.netty.handler.codec.http.websocketx.WebSocketVersion.V00) {
            return new WebSocketClientHandshaker00(webSocketURL, io.netty.handler.codec.http.websocketx.WebSocketVersion.V00, subprotocol, customHeaders, maxFramePayloadLength, -1L){

                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove(HttpHeaders.ORIGIN);
                    }
                    return request;
                }
            };
        }
        throw new WebSocketHandshakeException("Protocol version " + String.valueOf(version) + " not supported.");
    }

    ArrayList<WebSocketClientExtensionHandshaker> initializeWebSocketExtensionHandshakers(WebSocketClientOptions options) {
        ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketClientExtensionHandshaker>();
        if (options.getTryUsePerFrameCompression()) {
            extensionHandshakers.add((WebSocketClientExtensionHandshaker)new DeflateFrameClientExtensionHandshaker(options.getCompressionLevel(), false));
        }
        if (options.getTryUsePerMessageCompression()) {
            extensionHandshakers.add((WebSocketClientExtensionHandshaker)new PerMessageDeflateClientExtensionHandshaker(options.getCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, options.getCompressionAllowClientNoContext(), options.getCompressionRequestServerNoContext()));
        }
        return extensionHandshakers;
    }

    @Override
    protected void handleWriteQueueDrained() {
        Stream s = this.requests.peek();
        if (s != null) {
            s.context.execute(s::handleWriteQueueDrained);
        } else {
            super.handleWriteQueueDrained();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        ArrayList<Stream> allocatedStreams;
        ArrayList<Stream> sentStreams;
        super.handleClosed();
        this.closed = true;
        if (this.metrics != null) {
            HttpClientMetrics met = this.client.metrics();
            met.endpointDisconnected(this.metrics);
        }
        if (!this.evicted) {
            this.evicted = true;
            if (this.evictionHandler != null) {
                this.evictionHandler.handle(null);
            }
        }
        Iterator iterator = this;
        synchronized (iterator) {
            sentStreams = new ArrayList<Stream>(this.responses);
            allocatedStreams = new ArrayList<Stream>(this.requests);
            allocatedStreams.removeAll(this.responses);
        }
        for (Stream stream : allocatedStreams) {
            stream.context.execute(HttpUtils.CONNECTION_CLOSED_EXCEPTION, stream::handleClosed);
        }
        for (Stream stream : sentStreams) {
            if (this.metrics != null) {
                this.metrics.requestReset(stream.metric);
            }
            Object trace = stream.trace;
            VertxTracer tracer = stream.context.tracer();
            if (tracer != null && trace != null) {
                tracer.receiveResponse(stream.context, null, trace, HttpUtils.CONNECTION_CLOSED_EXCEPTION, TagExtractor.empty());
            }
            stream.context.execute(HttpUtils.CONNECTION_CLOSED_EXCEPTION, stream::handleClosed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleIdle(IdleStateEvent event) {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.responses.isEmpty() && this.requests.isEmpty()) {
                return;
            }
        }
        super.handleIdle(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(Throwable e) {
        super.handleException(e);
        LinkedHashSet<Stream> allStreams = new LinkedHashSet<Stream>();
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            allStreams.addAll(this.requests);
            allStreams.addAll(this.responses);
        }
        for (Stream stream : allStreams) {
            stream.handleException(e);
        }
    }

    @Override
    public Future<HttpClientStream> createStream(ContextInternal context) {
        PromiseInternal<HttpClientStream> promise = context.promise();
        this.createStream(context, promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStream(ContextInternal context, Promise<HttpClientStream> promise) {
        EventLoop eventLoop = context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            Object result;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                if (!this.closed) {
                    if ((long)this.requests.size() < this.concurrency()) {
                        StreamImpl stream = new StreamImpl(context, this, promise, this.seq++);
                        this.requests.add(stream);
                        if (this.requests.size() > 1) {
                            return;
                        }
                        result = stream;
                    } else {
                        result = new VertxException("Pipelining limit exceeded");
                    }
                } else {
                    result = HttpUtils.CONNECTION_CLOSED_EXCEPTION;
                }
            }
            if (result instanceof HttpClientStream) {
                promise.complete((HttpClientStream)result);
            } else {
                promise.fail((Throwable)result);
            }
        } else {
            eventLoop.execute(() -> this.createStream(context, promise));
        }
    }

    @Override
    public long lastResponseReceivedTimestamp() {
        return this.lastResponseReceivedTimestamp;
    }

    @Override
    public boolean isValid() {
        long now = System.currentTimeMillis();
        return now <= this.expirationTimestamp && now <= this.lifetimeEvictionTimestamp;
    }

    private static long expirationTimestampOf(long timeout) {
        return timeout > 0L ? System.currentTimeMillis() + timeout * 1000L : Long.MAX_VALUE;
    }

    public String toString() {
        return super.toString() + "[lastResponseReceivedTimestamp=" + this.lastResponseReceivedTimestamp + "]";
    }

    private static class StreamImpl
    extends Stream
    implements HttpClientStream {
        private final Http1xClientConnection conn;
        private final InboundMessageQueue<Object> queue;
        private boolean closed;
        private Handler<HttpResponseHead> headHandler;
        private Handler<Buffer> chunkHandler;
        private Handler<MultiMap> endHandler;
        private Handler<Void> drainHandler;
        private Handler<Void> continueHandler;
        private Handler<MultiMap> earlyHintsHandler;
        private Handler<Throwable> exceptionHandler;
        private Handler<Void> closeHandler;

        StreamImpl(final ContextInternal context, final Http1xClientConnection conn, Promise<HttpClientStream> promise, int id) {
            super(context, promise, id);
            this.conn = conn;
            this.queue = new InboundMessageQueue<Object>(conn.context.eventLoop(), context.executor()){

                @Override
                protected void handleResume() {
                    conn.doResume();
                }

                @Override
                protected void handlePause() {
                    conn.doPause();
                }

                @Override
                protected void handleMessage(Object item) {
                    if (item instanceof MultiMap) {
                        Handler<MultiMap> handler = endHandler;
                        if (handler != null) {
                            context.dispatch((MultiMap)item, handler);
                        }
                    } else {
                        Buffer buffer = (Buffer)item;
                        Handler<Buffer> handler = chunkHandler;
                        if (handler != null) {
                            context.dispatch(buffer, handler);
                        }
                    }
                }
            };
        }

        @Override
        public void continueHandler(Handler<Void> handler) {
            this.continueHandler = handler;
        }

        @Override
        public void earlyHintsHandler(Handler<MultiMap> handler) {
            this.earlyHintsHandler = handler;
        }

        public StreamImpl drainHandler(Handler<Void> handler) {
            this.drainHandler = handler;
            return this;
        }

        @Override
        public StreamImpl exceptionHandler(Handler<Throwable> handler) {
            this.exceptionHandler = handler;
            return this;
        }

        @Override
        public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
            return null;
        }

        @Override
        public boolean writeQueueFull() {
            return this.conn.writeQueueFull();
        }

        @Override
        public void headHandler(Handler<HttpResponseHead> handler) {
            this.headHandler = handler;
        }

        @Override
        public void closeHandler(Handler<Void> handler) {
            this.closeHandler = handler;
        }

        @Override
        public void priorityHandler(Handler<StreamPriority> handler) {
        }

        @Override
        public void pushHandler(Handler<HttpClientPush> handler) {
        }

        @Override
        public void unknownFrameHandler(Handler<HttpFrame> handler) {
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public Object metric() {
            return super.metric();
        }

        @Override
        public Object trace() {
            return super.trace();
        }

        @Override
        public HttpVersion version() {
            return this.conn.version;
        }

        @Override
        public HttpClientConnectionInternal connection() {
            return this.conn;
        }

        @Override
        public ContextInternal getContext() {
            return this.context;
        }

        @Override
        public Future<Void> writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, boolean connect) {
            PromiseInternal<Void> promise = this.context.promise();
            this.conn.writeHead(this, request, chunked, buf, end, connect, promise);
            return promise.future();
        }

        @Override
        public Future<Void> writeBuffer(ByteBuf buff, boolean end) {
            if (buff != null || end) {
                PromiseInternal<Void> listener = this.context.promise();
                this.conn.writeBuffer(this, buff, end, listener);
                return listener.future();
            }
            throw new IllegalStateException("???");
        }

        @Override
        public Future<Void> writeFrame(int type, int flags, ByteBuf payload) {
            throw new IllegalStateException("Cannot write an HTTP/2 frame over an HTTP/1.x connection");
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
            this.conn.doSetWriteQueueMaxSize(size);
        }

        @Override
        public boolean isNotWritable() {
            return this.conn.writeQueueFull();
        }

        @Override
        public void doPause() {
            this.queue.pause();
        }

        @Override
        public void doFetch(long amount) {
            this.queue.fetch(amount);
        }

        @Override
        public Future<Void> reset(Throwable cause) {
            PromiseInternal<Void> promise = this.context.promise();
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            if (eventLoop.inEventLoop()) {
                this.reset(cause, promise);
            } else {
                eventLoop.execute(() -> this.reset(cause, promise));
            }
            return promise.future();
        }

        private void reset(Throwable cause, Promise<Void> promise) {
            Boolean removed = this.conn.reset(this);
            if (removed == null) {
                promise.fail("Stream already reset");
            } else {
                if (removed.booleanValue()) {
                    this.context.execute(cause, this::handleClosed);
                } else {
                    this.context.execute(cause, this::handleException);
                }
                promise.complete();
            }
        }

        @Override
        public StreamPriority priority() {
            return null;
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleWriteQueueDrained(Void v) {
            Handler<Void> handler;
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                handler = this.drainHandler;
            }
            if (handler != null) {
                this.context.dispatch(handler);
            }
        }

        @Override
        void handleContinue() {
            Handler<Void> handler = this.continueHandler;
            if (handler != null) {
                this.context.emit(null, handler);
            }
        }

        @Override
        void handleEarlyHints(MultiMap headers) {
            Handler<MultiMap> handler = this.earlyHintsHandler;
            if (handler != null) {
                this.context.emit(headers, handler);
            }
        }

        @Override
        void handleHead(HttpResponseHead response) {
            Handler<HttpResponseHead> handler = this.headHandler;
            if (handler != null) {
                this.context.emit(response, handler);
            }
        }

        @Override
        public void chunkHandler(Handler<Buffer> handler) {
            this.chunkHandler = handler;
        }

        @Override
        public void endHandler(Handler<MultiMap> handler) {
            this.endHandler = handler;
        }

        @Override
        void handleChunk(Buffer buff) {
            this.queue.write(buff);
        }

        @Override
        void handleEnd(LastHttpContent trailer) {
            this.queue.write((Object)new HeadersAdaptor(trailer.trailingHeaders()));
        }

        @Override
        void handleException(Throwable cause) {
            Handler<Throwable> handler = this.exceptionHandler;
            if (handler != null) {
                this.context.emit(cause, handler);
            }
        }

        @Override
        void handleClosed(Throwable err) {
            if (err != null) {
                this.handleException(err);
                this.promise.tryFail(err);
            }
            if (!this.closed) {
                this.closed = true;
                Handler<Void> handler = this.closeHandler;
                if (handler != null) {
                    this.context.emit(null, handler);
                }
            }
        }
    }

    private static abstract class Stream {
        protected final Promise<HttpClientStream> promise;
        protected final ContextInternal context;
        protected final int id;
        private Object trace;
        private Object metric;
        private HttpRequestHead request;
        private HttpResponseHead response;
        private boolean requestEnded;
        private boolean responseEnded;
        private long bytesRead;
        private long bytesWritten;
        private boolean reset;

        Stream(ContextInternal context, Promise<HttpClientStream> promise, int id) {
            this.context = context;
            this.id = id;
            this.promise = promise;
        }

        Object metric() {
            return this.metric;
        }

        Object trace() {
            return this.trace;
        }

        abstract void handleContinue();

        abstract void handleEarlyHints(MultiMap var1);

        abstract void handleHead(HttpResponseHead var1);

        abstract void handleChunk(Buffer var1);

        abstract void handleEnd(LastHttpContent var1);

        abstract void handleWriteQueueDrained(Void var1);

        abstract void handleException(Throwable var1);

        abstract void handleClosed(Throwable var1);
    }
}

